function results=gradjcompute_core(models,inputs);

%recover active models
m=models.active;

%recover parameters
verbose=m.parameters.Verbose;
dim=m.parameters.Dim;
extrude_param=m.parameters.ExtrudeParam;
ishutter=m.parameters.IsHutter;
ismacayealpattyn=m.parameters.IsMacAyealPattyn;
isstokes=m.parameters.IsStokes;
analysis_type=m.parameters.AnalysisType;
sub_analysis_type=m.parameters.SubAnalysisType;

%Recover solution for this stiffness and right hand side: 
displaystring(verbose,'%s','         computing velocities...');
[u_g K_ff0 K_fs0 ]=diagnostic_core_nonlinear(m,analysis_type,sub_analysis_type);
inputs=add(inputs,'velocity',u_g,'doublevec',m.parameters.NumberOfDofsPerNode,m.parameters.NumberOfNodes);

%Buid Du, difference between observed velocity and model velocity.
displaystring(verbose,'%s','          computing Du...');
[Du_g]=Du(m.elements,m.nodes,m.vertices,m.loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);

%Reduce adjoint load from g-set to f-set
[Du_f] = Reduceloadfromgtof( Du_g, m.Gmn, K_fs0, m.ys0, m.nodesets);

%Solve for adjoint vector: 
displaystring(verbose,'%s','          computing adjoint state...');
lambda_f=Solver(K_ff0,Du_f,[],m.parameters);

%Merge back to g set
lambda_g= Mergesolutionfromftog( lambda_f, m.Gmn, m.ys0, m.nodesets ); 
inputs=add(inputs,'adjoint',lambda_g,'doublevec',m.parameters.NumberOfDofsPerNode,m.parameters.NumberOfNodes);

%Compute gradJ 
grad_g=Gradj(m.elements,m.nodes,m.vertices,m.loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
if (dim==3 & extrude_param),
	displaystring(verbose,'%s','          extruding gradient...');
	grad_g=FieldExtrude(m.elements,m.nodes,m.vertices,m.loads,m.materials,m.parameters,grad_g,'gradj',0);
end

if m.parameters.ControlSteady,
	%compute initial velocity from diagnostic_core (horiz+vertical)
	displaystring(verbose,'%s','          compute 3d initial velocity...');
	results_diag=diagnostic_core(models,inputs);
	u_g=results_diag.u_g;
end

%Assign output
results.u_g=u_g;
results.grad_g=grad_g;
