function J =objectivefunctionC(search_scalar,models,inputs,p_g,grad_g,n,analysis_type,sub_analysis_type);

%recover active model.
m=models.active;

%recover some parameters
optscal=m.parameters.Optscal(n);
fit=m.parameters.Fit(n);
control_type=m.parameters.ControlType;
analysis_type=m.parameters.AnalysisType;

%Update along gradient using scalar supplied by fmincon optimization routine
parameter=p_g+search_scalar*optscal*grad_g;

%Plug parameter into inputs
inputs=add(inputs,m.parameters.ControlType,parameter,'doublevec',1,m.parameters.NumberOfNodes);

%Run diagnostic with updated parameters.
u_g=diagnostic_core_nonlinear(m,inputs,analysis_type,sub_analysis_type);

%add velocity to inputs.
inputs=add(inputs,'velocity',u_g,'doublevec',m.parameters.NumberOfDofsPerNode,m.parameters.NumberOfNodes);

%Compute misfit for this velocity field. 
J=CostFunction(m.elements,m.nodes,m.vertices,m.loads,m.materials,m.parameters,inputs,analysis_type,sub_analysis_type);
