function [slopex, slopey]=slope_core(fem,AnalysisEnum)
%SLOPE_CORE - Core solution to compute the slope
%
%    Usage: 
%       [slopex, slopey]=slope_core(fem,AnalysisEnum)
%
%    Examples: 
%       [bedslopex, bedslopey]=slope_core(fem,BedEnum);
%       [surfaceslopex, surfaceslopey]=slope_core(fem,SurfaceEnum);
%

verbose=fem.parameters.Verbose;
dim=fem.parameters.Dim;
isstokes=fem.parameters.IsStokes;
ishutter=fem.parameters.IsHutter;

displaystring(verbose,'\n%s',['computing slope (x and y derivatives...)']);

%Specify type of computations: 
if AnalysisEnum==SurfaceAnalysisEnum,
	xanalysis=SurfaceXAnalysisEnum;
	yanalysis=SurfaceYAnalysisEnum;
elseif AnalysisEnum==BedAnalysisEnum,
	xanalysis=BedXAnalysisEnum;
	yanalysis=BedYAnalysisEnum;
else
	displaystring(verbose,'%s%s%s','analysis ',EnumAsString(AnalysisEnum),' not supported yet!');
end

%Early return possible?
if ~ishutter && AnalysisEnum==SurfaceAnalysisEnum,
	%no need to compute Surface Slope except for Hutter: 
	slopex=[];
	slopey=[];
	return;
end
	
if ~isstokes && AnalysisEnum==BedAnalysisEnum,
	%no need to compute Bed Slope except for full Stokes:

	slopex=[];
	slopey=[];
	return;
end
	
%Call on core computations: 
slopex=diagnostic_core_linear(fem,SlopecomputeAnalysisEnum,xanalysis);
slopey=diagnostic_core_linear(fem,SlopecomputeAnalysisEnum,yanalysis);

%extrude if we are in 3D: 
if dim==3,
	displaystring(verbose,'%s\n','extruding slopes in 3d...');
	slopex=FieldExtrude(fem.elements,fem.nodes,fem.vertices,fem.loads,fem.materials,fem.parameters,slopex,'slopex',1);
	slopey=FieldExtrude(fem.elements,fem.nodes,fem.vertices,fem.loads,fem.materials,fem.parameters,slopex,'slopey',1);
end

