/*!\file BoolParam.c
 * \brief: implementation of the BoolParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION BoolParam::BoolParam(){{{1*/
BoolParam::BoolParam(){
	return;
}
/*}}}*/
/*FUNCTION BoolParam::BoolParam(int enum_type,IssmBool value){{{1*/
BoolParam::BoolParam(int in_enum_type,IssmBool in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION BoolParam::~BoolParam(){{{1*/
BoolParam::~BoolParam(){
	return;
}
/*}}}*/

/*Object methods*/
/*FUNCTION BoolParam::copy{{{1*/
Object* BoolParam::copy() {
	
	return new BoolParam(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION BoolParam::DeepEcho{{{1*/
void BoolParam::DeepEcho(void){

	printf("BoolParam:\n");
	printf("   enum:  %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %s\n",this->value?"true":"false");
}
/*}}}*/
/*FUNCTION BoolParam::Demarshall{{{1*/
void  BoolParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION BoolParam::Echo {{{1*/
void BoolParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BoolParam::Enum{{{1*/
int BoolParam::Enum(void){

	return BoolParamEnum;

}
/*}}}*/
/*FUNCTION BoolParam::Id{{{1*/
int    BoolParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BoolParam::Marshall{{{1*/
void  BoolParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of BoolParam: */
	enum_value=BoolParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall BoolParam data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION BoolParam::MarshallSize{{{1*/
int   BoolParam::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION BoolParam::MyRank{{{1*/
int    BoolParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION BoolParam::GetParameterName(void); {{{1*/
char* BoolParam::GetParameterName(void){
	return  EnumAsString(this->enum_type);
}
/*}}}*/
/*FUNCTION BoolParam::ProcessParams(double* partition,int numberofvertices);{{{1*/
void  BoolParam::Process(double* partition,int numberofvertices){
}
/*}}}*/
/*FUNCTION BoolParam::SetMatlabField(mxArray* dataref);{{{1*/
#ifdef _SERIAL_
void  BoolParam::SetMatlabField(mxArray* dataref){
	char* name=NULL;
	name=this->GetParameterName();
	mxSetField( dataref, 0, name,mxCreateDoubleScalar((double)value));
}
#endif
/*}}}*/
