/*!\file: prognostic_core.cpp
 * \brief: core of the prognostic solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./parallel.h"
#include "../modules.h"

void prognostic_core(DataSet* results,Model* model){

	extern int my_rank;

	/*output: */
	Result* result=NULL;

	/*solutions: */
	Vec h_g=NULL;

	/*flags: */
	int verbose=0;

	/*fem prognostic model: */
	FemModel* fem_p=NULL;


	/*recover fem model: */
	fem_p=model->GetFormulation(PrognosticAnalysisEnum); ISSMASSERT(fem_p);

	//first recover parameters common to all solutions
	model->FindParam(&verbose,VerboseEnum);

	_printf_("depth averaging velocity...\n");
	DepthAverageInputx(fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,VxEnum);
	DepthAverageInputx(fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,VyEnum);
	
	_printf_("call computational core:\n");
	diagnostic_core_linear(&h_g,fem_p,PrognosticAnalysisEnum,NoneAnalysisEnum);
		
	_printf_("update inputs:\n");
	fem_p->UpdateInputsFromSolution(h_g,PrognosticAnalysisEnum,NoneAnalysisEnum);

	_printf_("extrude computed thickness on all layers:\n");
	ExtrudeInputx(fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,ThicknessEnum);
	
	_printf_("extract result from extruded inputs: \n");
	InputToResult(&result,fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,ThicknessEnum,results->Size()+1,0,1);
	results->AddObject(result);

	/*Free ressources:*/
	VecFree(&h_g);
}
