/* \file Exceptions.cpp
 * \brief: implementation of the exceptions.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "../shared.h"
#include "../../include/include.h"

ErrorException::ErrorException(const string &what_arg){

	what_str=what_arg;
	file_name="";
	function_name="";
	file_line=0;
}

ErrorException::ErrorException(string what_file,string what_function,int what_line,string what_arg){

	what_str=what_arg;
	file_name=what_file;
	function_name=what_function;
	file_line=what_line;
}

ErrorException::~ErrorException() throw(){
}

const char* ErrorException::what() const throw(){
	return what_str.c_str();
}

void ErrorException::Report(){
	extern int my_rank;

	if (function_name=="" || file_line==0){ //WINDOWS
		printf("%s%s","Error message: ",what());
	}
	else{
		#ifdef _PARALLEL_
			printf("\n[%i] %s%s%s%i\n",my_rank,"??? Error using ==> ",file_name.c_str()," at ",file_line);
			printf("[%i] %s%s%s\n\n",my_rank,function_name.c_str()," error message: ",what());
		#else
			printf("\n%s%s%s%i\n","??? Error using ==> ",file_name.c_str()," at ",file_line);
			printf("%s%s%s\n\n",function_name.c_str()," error message: ",what());
		#endif
	}
	return;
}
