/*!\file BeamVertexInput.c
 * \brief: implementation of the BeamVertexInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION BeamVertexInput::BeamVertexInput(){{{1*/
BeamVertexInput::BeamVertexInput(){
	return;
}
/*}}}*/
/*FUNCTION BeamVertexInput::BeamVertexInput(double* values){{{1*/
BeamVertexInput::BeamVertexInput(int in_enum_type,double* in_values){

	enum_type=in_enum_type;
	values[0]=in_values[0];
	values[1]=in_values[1];
}
/*}}}*/
/*FUNCTION BeamVertexInput::~BeamVertexInput(){{{1*/
BeamVertexInput::~BeamVertexInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION BeamVertexInput::copy{{{1*/
Object* BeamVertexInput::copy() {
	
	return new BeamVertexInput(this->enum_type,this->values);

}
/*}}}*/
/*FUNCTION BeamVertexInput::DeepEcho{{{1*/
void BeamVertexInput::DeepEcho(void){

	printf("BeamVertexInput:\n");
	printf("   enum: %i\n",this->enum_type);
	printf("   %g|%g\n",this->values[0],this->values[1]);
}
/*}}}*/
/*FUNCTION BeamVertexInput::Demarshall{{{1*/
void  BeamVertexInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION BeamVertexInput::Echo {{{1*/
void BeamVertexInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BeamVertexInput::Enum{{{1*/
int BeamVertexInput::Enum(void){

	return BeamVertexInputEnum;

}
/*}}}*/
/*FUNCTION BeamVertexInput::EnumType{{{1*/
int BeamVertexInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION BeamVertexInput::Id{{{1*/
int    BeamVertexInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BeamVertexInput::Marshall{{{1*/
void  BeamVertexInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of BeamVertexInput: */
	enum_value=BeamVertexInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall BeamVertexInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION BeamVertexInput::MarshallSize{{{1*/
int   BeamVertexInput::MarshallSize(){
	
	return sizeof(values)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum_value
}
/*}}}*/
/*FUNCTION BeamVertexInput::MyRank{{{1*/
int    BeamVertexInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Object functions*/
/*FUNCTION BeamVertexInput::GetParameterValue(bool* pvalue) {{{1*/
void BeamVertexInput::GetParameterValue(bool* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(int* pvalue){{{1*/
void BeamVertexInput::GetParameterValue(int* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(double* pvalue){{{1*/
void BeamVertexInput::GetParameterValue(double* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(double* pvalue,Node* node){{{1*/
void BeamVertexInput::GetParameterValue(double* pvalue,Node* node){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){{{1*/
void BeamVertexInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(double* pvalue,double* gauss){{{1*/
void BeamVertexInput::GetParameterValue(double* pvalue,double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){{{1*/
void BeamVertexInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){{{1*/
void BeamVertexInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){{{1*/
void BeamVertexInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetStrainRate(double* epsilon,Input* yinput, double* xyz_list, double* gauss){{{1*/
void BeamVertexInput::GetStrainRate(double* epsilon,Input* yinput,double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetStrainRateStokes(double* epsilon,Input* yinput, Input* zinput, double* xyz_list, double* gauss){{{1*/
void BeamVertexInput::GetStrainRateStokes(double* epsilon,Input* yinput,Input* zinput, double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::ChangeEnum(int newenumtype){{{1*/
void BeamVertexInput::ChangeEnum(int newenumtype){
	this->enum_type=newenumtype;
}
/*}}}*/
