#ifndef _GEOMETRY_H_
#define _GEOMETRY_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"

#include "../include/include.h"
#include "MeshVertex.h"
#include "Edge.h"
#include "GeometricalVertex.h"
#include "GeometricalEdge.h"
#include "Curve.h"
#include "Triangle.h"
#include "GeometricalSubDomain.h"
#include "SubDomain.h"
#include "VertexOnGeom.h"
#include "QuadTree.h"

namespace bamg {

	class Geometry { 

		public:
			long NbRef;     // counter of ref on the this class if 0 we can delete
			long nbvx,nbtx; // maximum number of vertices
			long nbv,nbt,nbiv,nbe; // number of vertices
			long NbSubDomains; // 
			long NbOfCurves;
			GeometricalVertex* vertices;
			Triangle* triangles; 
			GeometricalEdge* edges;
			QuadTree* quadtree;
			GeometricalSubDomain* subdomains;
			Curve* curves;
			R2 pmin,pmax; // extrema
			double coefIcoor;  // coef to integer Icoor1;
			double MaximalAngleOfCorner;

			//Constructor/Destructors
			~Geometry(); 
			Geometry(const Geometry & Gh); //Copy  Operator 
			Geometry(int nbg,const Geometry** ag); // intersection operator 

			//Operators
			const GeometricalVertex & operator[]  (long i) const { return vertices[i];};
			GeometricalVertex & operator[](long i) { return vertices[i];};
			const  GeometricalEdge & operator()  (long i) const { return edges[i];};
			GeometricalEdge & operator()(long i) { return edges[i];}; 

			//Methods
			int empty(){return (nbv ==0) && (nbt==0) && (nbe==0) && (NbSubDomains==0); }
			void Echo();
			I2 toI2(const R2 & P) const {
				return  I2( (Icoor1) (coefIcoor*(P.x-pmin.x))
							,(Icoor1) (coefIcoor*(P.y-pmin.y)) );}
			double MinimalHmin() {return 2.0/coefIcoor;}
			double MaximalHmax() {return Max(pmax.x-pmin.x,pmax.y-pmin.y);}
			void ReadGeometry(BamgGeom* bamggeom, BamgOpts* bamgopts);
			void EmptyGeometry();
			Geometry() {EmptyGeometry();}// empty Geometry
			void AfterRead();
			Geometry(BamgGeom* bamggeom, BamgOpts* bamgopts) {EmptyGeometry();ReadGeometry(bamggeom,bamgopts);AfterRead();}
			long Number(const GeometricalVertex & t) const  { return &t - vertices;}
			long Number(const GeometricalVertex * t) const  { return t - vertices;}
			long Number(const GeometricalEdge & t) const  { return &t - edges;}
			long Number(const GeometricalEdge * t) const  { return t - edges;}
			long Number(const Curve * c) const  { return c - curves;}
			void UnMarkEdges() {for (int i=0;i<nbe;i++) edges[i].SetUnMark();}
			GeometricalEdge *  ProjectOnCurve(const Edge & ,double,MeshVertex &,VertexOnGeom &) const ;
			GeometricalEdge *  Containing(const R2 P,  GeometricalEdge * start) const;
			void WriteGeometry(BamgGeom* bamggeom, BamgOpts* bamgopts);
	};
	
}
#endif
