function solution=controlfinalsol(c,m,p_g,inputs,analysis_type);

%From parameters, build inputs for icediagnostic_core, using the final parameters
inputs=add(inputs,m.parameters.control_type,p_g,'doublevec',2,m.parameters.numberofnodes);
u_g=diagnostic_core_nonlinear(m,inputs,analysis_type);

%Build partitioning vectors to recover solution
indx=[1:2:m.nodesets.gsize];
indy=[2:2:m.nodesets.gsize];

%Recover velocity, and parameters, in the correct partitioning.
vx=u_g(indx);
vy=u_g(indy);
vel=sqrt(vx.^2+vy.^2);
parameter=p_g(indx);

%Recover misfit at each iteration of the control method 
J=zeros(length(c),1);
for i=1:length(c),
	J(i)=c(i).J;
end

%Store in solution
solution.vx=vx;
solution.vy=vy;
solution.vel=vel;
solution.J=J;
solution.parameter=parameter;
