/*\file ControlOptimization.c
 *\brief: control optimization (replaces fmincon from matlab)
 */
 

#include "./ControlOptimization.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	char* function_name=NULL;
	double xmin,xmax;
	double tolerance;
	int    maxiter;
	OptArgs optargs;
	OptPars optpars;

	/*output: */
	double search_scalar;
	double J;

	/*arguments to objectivefunctionC: */
	mxArray* m=NULL;
	mxArray* pg=NULL;
	mxArray* u_g_obs=NULL;
	mxArray* grad_g=NULL;
	mxArray* n=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ControlOptimizationUsage);

	/*Input datasets: */
	FetchData((void**)&function_name,NULL,NULL,FUNCTIONNAME,"String",NULL);
	FetchData((void**)&xmin,NULL,NULL,XMIN,"Scalar",NULL);
	FetchData((void**)&xmax,NULL,NULL,XMAX,"Scalar",NULL);
	FetchData((void**)&tolerance,NULL,NULL,mxGetField(OPTIONS,0,"TolX"),"Scalar",NULL);
	FetchData((void**)&maxiter,NULL,NULL,mxGetField(OPTIONS,0,"MaxIter"),"Integer",NULL);

	optargs.function_name=function_name;
	optargs.m=MODEL;
	optargs.p_g=PG; 
	optargs.inputs=INPUTS;
	optargs.u_g_obs=VELOBS;
	optargs.grad_g=GRADIENT;
	optargs.n=STEP;
	optargs.analysis_type=ANALYSIS;

	optpars.xmin=xmin;
	optpars.xmax=xmax;
	optpars.tolerance=tolerance;
	optpars.maxiter=maxiter;

	BrentSearch(&search_scalar,&J,&optpars,&OptFunc,&optargs);

	/*write output : */
	WriteData(SEARCHSCALAR,&search_scalar,0,0,"Scalar",NULL);
	WriteData(MISFIT,&J,0,0,"Scalar",NULL);

	/*Free ressources: */
	xfree((void**)&function_name);

	/*end module: */
	MODULEEND();
}

void ControlOptimizationUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [search_scalar J] = %s(function_name,xmin,xmax,options,m,inputs,p_g,u_g_obs,grad_g,step,analysis_type)\n",__FUNCT__);
	_printf_("\n");
}
