/*! \file PetscMatParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _PETSCMATPARAM_H_
#define _PETSCMATPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class PetscMatParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		Mat value;

	public:
		/*constructors, destructors: {{{1*/
		PetscMatParam();
		PetscMatParam(int enum_type,Mat value);
		~PetscMatParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("PetscMat param cannot return a bool");}
		void  GetParameterValue(int* pinteger){ISSMERROR("PetscMat param cannot return an integer");}
		void  GetParameterValue(double* pdouble){ISSMERROR("PetscMat param cannot return a double");}
		void  GetParameterValue(char** pstring){ISSMERROR("PetscMat param cannot return a string");}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("PetscMat param cannot return a string arrayl");}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("PetscMat param cannot return a double array");}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("PetscMat param cannot return a double array");}
		void  GetParameterValue(Vec* pvec){ISSMERROR("PetscMat param cannot return a vec");}
		void  GetParameterValue(Mat* poutput);
		char* GetParameterName(void);
		void  Process(double* partition,int numberofvertices);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _PETSCMATPARAM_H */
