/* \file IoModel.h
 * \brief  Header file defining the IoModel structure that will help in processing the input data coming 
 * into ISSM, from Matlab, or through a binary file opened for reading.
 * \sa IoModel.cpp
 */

#ifndef _IOMODEL_H
#define _IOMODEL_H

#include "../include/include.h"

class IoModel {

	public:

		/*Data: {{{1*/
		char*   name;
		char*	  inputfilename;
		char*	  outputfilename;
		char*   repository;
		char*   meshtype;
		int     analysis_type;
		int     sub_analysis_type;
		int     qmu_analysis;
		int     control_analysis;
		char*   solverstring;

		/*2d mesh: */
		int     numberofelements;
		int     numberofvertices;
		double* x;
		double* y;
		double* z;
		double* elements;
		double* elements_type;

		/*3d mesh: */
		int     numberofvertices2d;
		int     numberofelements2d;
		double* elements2d;
		double* deadgrids;
		int     numlayers;
		double* uppernodes;

		/*elements type: */
		int     ishutter;
		int     ismacayealpattyn;
		int     isstokes;
		double* gridonhutter;
		double* gridonmacayeal;
		double* gridonpattyn;

		/*results: */
		double* vx;
		double* vy;
		double* vz;
		double* pressure;
		double* temperature;

		/*observations: */
		double*  vx_obs;
		double*  vy_obs;
		double*  vz_obs;

		/*qmu: */
		int      numberofresponses;
		int      numberofvariables;
		int      qmu_npart;

		/*geometry: */
		double* elementonbed;
		double* elementonsurface;
		double* gridonbed;
		double* gridonsurface;
		double* gridonstokes;
		double* borderstokes;
		double* thickness;
		double* surface;
		double* bed;
		double* elementoniceshelf;
		double* elementonwater;
		double* gridonicesheet;
		double* gridoniceshelf;

		/*friction: */
		int     drag_type;
		double* drag_coefficient;
		double* drag_p;
		double* drag_q;

		/*boundary conditions: */
		int     numberofpressureloads;
		double* pressureload;
		double* spcvelocity;
		double* spctemperature;
		double* spcthickness;
		double* geothermalflux;
		int     numberofedges;
		double* edges;

		/*materials: */
		double  rho_water,rho_ice;
		double  g;
		double* rheology_B;
		double* rheology_n;

		/*numerical parameters: */
		double  meanvel;
		double  epsvel;
		int     artdiff;
		double  viscosity_overshoot;
		double  stokesreconditioning;
		double  cm_noisedmp;
		double  cm_mindmp_value;
		double  cm_mindmp_slope;
		double  cm_maxdmp_value;
		double  cm_maxdmp_slope;
		double  cm_min;
		double  cm_max;
		int     cm_gradient;;

		double  cm_noisedampening;

		/*control methods: */
		char*	control_type;

		/*solution parameters: */
		double* fit;
		double* weights;
		double* cm_jump;
		int     artificial_diffusivity;
		int     nsteps;
		double  eps_cm;
		double  tolx;
		double* maxiter;
		int     verbose;
		int     plot;
		double  eps_res;
		double  eps_rel;
		double  eps_abs;
		double  max_nonlinear_iterations;
		double  dt,ndt;
		double  penalty_offset;
		double  penalty_melting;
		int     penalty_lock;
		double  sparsity;
		int     connectivity;
		int     lowmem;
		double* optscal;
		double  yts;
		double  waitonlock;

		/*thermal parameters: */
		double beta;
		double meltingpoint;
		double latentheat;
		double  heatcapacity,thermalconductivity;
		int    min_thermal_constraints;
		int    min_mechanical_constraints;
		int    stabilize_constraints;
		double mixed_layer_capacity;
		double thermal_exchange_velocity;

		/*rifts: */
		int      numrifts;
		double*  riftinfo;

		/*penalties: */
		int      numpenalties;
		double*  penalties;

		/*basal: */
		double*  melting_rate;
		double*  accumulation_rate;
		double*  dhdt;

		/*parameter output: */
		int      numoutput;

		/*exterior partitioning data, to be carried around: */
		bool*   my_elements;
		bool*   my_vertices;
		bool*   my_nodes;
		bool*   my_bordervertices;
		int*    penaltypartitioning;
		int*    singlenodetoelementconnectivity;
		/*}}}*/
		/*Methods: {{{1*/
		~IoModel();
		IoModel();
		IoModel(ConstDataHandle iomodel_handle);
		void IoModelInit(void);
		void Echo(int which_part,int rank);
		/*}}}*/

};

#endif  /* _IOMODEL_H */
