/*!\file:  WriteDataToDisk.cpp
 * \brief
 */ 

#include "stdio.h"
#include "string.h"
#include "../include/include.h"
#include "../shared/shared.h"

void WriteDataToDisk(void* data,int* pM,int* pN,char* datatype,FILE* fid){
	
	/*Pendant of the ISSM WriteData routine: */

	double datatype_code;
	
	/*string:*/
	char*  string=NULL;
	double string_size=0;

	/*matrix: */
	double* matrix=NULL;
	double  M,N;

	/*integer:*/
	double  integer;

	/*scalar:*/
	double  scalar;

	if (strcmp(datatype,"String")==0){
		string=(char*)data;
		string_size=(double)((strlen(string)+1)*sizeof(char));
		datatype_code=0;

		fwrite(&datatype_code,sizeof(double),1,fid);
		fwrite(&string_size,sizeof(double),1,fid);
		fwrite(string,(int)string_size,1,fid);
	}
	else if (strcmp(datatype,"Mat")==0){
		matrix=(double*)data;
		M=*pM;
		N=*pN;
		datatype_code=1;

		fwrite(&datatype_code,sizeof(double),1,fid);
		fwrite(&M,sizeof(double),1,fid);
		fwrite(&N,sizeof(double),1,fid);
		fwrite(matrix,(int)(M*N*sizeof(double)),1,fid);

	}
	else if (strcmp(datatype,"Integer")==0){
		integer=(double)*((int*)data);
		datatype_code=2;
		fwrite(&datatype_code,sizeof(double),1,fid);
		fwrite(&integer,sizeof(double),1,fid);

	}
	else if (strcmp(datatype,"Scalar")==0){
		
		scalar=(double)(*(double*)data);
		datatype_code=3;
		fwrite(&datatype_code,sizeof(double),1,fid);
		fwrite(&scalar,sizeof(double),1,fid);

	}
	else{
		ISSMERROR("data type not supported yet!");
	}
}
