/* \file Exceptions.cpp
 * \brief: implementation of the exceptions.
 */

#include "../shared.h"
#include "../../include/include.h"

ErrorException::ErrorException(const string &what_arg){

	what_str=what_arg;
	file_name="";
	function_name="";
	file_line=0;
}

ErrorException::ErrorException(string what_file,string what_function,int what_line,string what_arg){

	what_str=what_arg;
	file_name=what_file;
	function_name=what_function;
	file_line=what_line;
}

ErrorException::~ErrorException() throw(){
}

const char* ErrorException::what() const throw(){
	return what_str.c_str();
}

void ErrorException::Report(){

	if (function_name=="" || file_line==0){ //WINDOWS
		_printf_("%s%s","Error message: ",what());
	}
	else{
		_printf_("\n%s%s%s%i\n","??? Error using ==> ",file_name.c_str()," at ",file_line);
		_printf_("%s%s%s\n\n",function_name.c_str()," error message: ",what());
	}
	return;
}
