/*!\file DoubleParam.c
 * \brief: implementation of the DoubleParam object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION DoubleParam::DoubleParam(){{{1*/
DoubleParam::DoubleParam(){
	return;
}
/*}}}*/
/*FUNCTION DoubleParam::DoubleParam(int enum_type,IssmDouble value){{{1*/
DoubleParam::DoubleParam(int in_enum_type,IssmDouble in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION DoubleParam::~DoubleParam(){{{1*/
DoubleParam::~DoubleParam(){
	return;
}
/*}}}*/

/*Object methods*/
/*FUNCTION DoubleParam::copy{{{1*/
Object* DoubleParam::copy() {
	
	return new DoubleParam(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION DoubleParam::DeepEcho{{{1*/
void DoubleParam::DeepEcho(void){

	printf("DoubleParam:\n");
	printf("   enum:  %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %g\n",this->value);
}
/*}}}*/
/*FUNCTION DoubleParam::Demarshall{{{1*/
void  DoubleParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DoubleParam::Echo {{{1*/
void DoubleParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleParam::Enum{{{1*/
int DoubleParam::Enum(void){

	return DoubleParamEnum;

}
/*}}}*/
/*FUNCTION DoubleParam::Id{{{1*/
int    DoubleParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleParam::Marshall{{{1*/
void  DoubleParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleParam: */
	enum_value=DoubleParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleParam data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleParam::MarshallSize{{{1*/
int   DoubleParam::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleParam::MyRank{{{1*/
int    DoubleParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleParam::GetParameterName(void); {{{1*/
char* DoubleParam::GetParameterName(void){
	return  EnumAsString(this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleParam::ProcessParams(double* partition,int numberofvertices);{{{1*/
void  DoubleParam::Process(double* partition,int numberofvertices){
}
/*}}}*/
/*FUNCTION DoubleParam::SetMatlabField(mxArray* dataref);{{{1*/
#ifdef _SERIAL_
void  DoubleParam::SetMatlabField(mxArray* dataref){

	char* name=NULL;
	name=this->GetParameterName();
	mxSetField( dataref, 0, name,mxCreateDoubleScalar(value));
	xfree((void**)&name);
}
#endif
/*}}}*/
