/*! \file DoubleMatParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _DOUBLEMATPARAM_H_
#define _DOUBLEMATPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class DoubleMatParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		IssmDouble* value;
		int M;
		int N;

	public:
		/*constructors, destructors: {{{1*/
		DoubleMatParam();
		DoubleMatParam(int enum_type,IssmDouble* value,int M,int N);
		~DoubleMatParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("DoubleMat param cannot return a bool");}
		void  GetParameterValue(int* pinteger){ISSMERROR("DoubleMat param cannot return an integer");}
		void  GetParameterValue(double* pdouble){ISSMERROR("DoubleMat param cannot return a double");}
		void  GetParameterValue(char** pstring){ISSMERROR("DoubleMat param cannot return a string");}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("DoubleMat param cannot return a string arrayl");}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("DoubleMat param cannot return a double array");}
		void  GetParameterValue(double** pdoublearray,int* pM,int* pN);
		void  GetParameterValue(Vec* pvec){ISSMERROR("DoubleMat param cannot return a Vec");}
		void  GetParameterValue(Mat* pmat){ISSMERROR("DoubleMat param cannot return a Mat");}
		char* GetParameterName(void);
		void  Process(double* partition,int numberofvertices);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _DOUBLEMATPARAM_H */
