/*! \file Model.h 
 *  \brief: header file for model object
 */

#ifndef _MODEL_H_
#define _MODEL_H_

/*Headers:*/
/*{{{1*/
#include "../include/include.h"
struct FemModel;
class DataSet;
/*}}}*/

class Model{

	private: 

		/*femmodels for each formulation: dynamic, can have as many*/
		DataSet* femmodels;
		
		/*active femmodel: points to a FemModel in the femmodels dataset*/
		FemModel* active;

	public:

		Model();
		~Model();

		void  Echo();
		void  DeepEcho();

		void  AddFormulation(ConstDataHandle MODEL, int analysis_type,int sub_analysis_type);
		void  AddFormulation(ConstDataHandle MODEL, int analysis_type);

		/*all overloaded forms of the FindParam routine: */
		int   FindParam(bool* pparameter,int enum_type);
		int   FindParam(int* pparameter,int enum_type);
		int   FindParam(double* pparameter,int enum_type);
		int   FindParam(double** pparameter,int* pM,int* pN,int enum_type);
		int   FindParam(double** pparameter,int* pM,int enum_type);
		int   FindParam(char** pparameter,int enum_type);

		int   FindParamByAnalysisAndSub(bool* pparameter,int enum_type,int analysis_type,int sub_analysis_type);
		int   FindParamByAnalysisAndSub(int* pparameter,int enum_type,int analysis_type,int sub_analysis_type);
		int   FindParamByAnalysisAndSub(double* pparameter,int enum_type,int analysis_type,int sub_analysis_type);
		int   FindParamByAnalysisAndSub(double** pparameter,int* pM, int enum_type,int analysis_type,int sub_analysis_type);
		int   FindParamByAnalysisAndSub(double** pparameter,int* pM, int* pN,int enum_type,int analysis_type,int sub_analysis_type);
		int   FindParamByAnalysisAndSub(char** pparameter,int enum_type,int analysis_type,int sub_analysis_type);

		int   FindParamByAnalysis(bool* pparameter,int enum_type,int analysis_type);
		int   FindParamByAnalysis(int* pparameter,int enum_type,int analysis_type);
		int   FindParamByAnalysis(double* pparameter,int enum_type,int analysis_type);
		int   FindParamByAnalysis(double** pparameter,int* pM,int enum_type,int analysis_type);
		int   FindParamByAnalysis(double** pparameter,int* pM,int* pN,int enum_type,int analysis_type);
		int   FindParamByAnalysis(char** pparameter,int enum_type,int analysis_type);

		FemModel* GetFormulation(int analysis_type,int sub_analysis_type);
		FemModel* GetFormulation(int analysis_type);

		void    UpdateInputsFromVector(Vec vector, int name, int type);
		void    UpdateInputsFromVector(double* vector, int name, int type);
		void    UpdateInputsFromVector(int* vector, int name, int type);
		void    UpdateInputsFromVector(bool* vector, int name, int type);
		void    UpdateInputsFromConstant(double constant, int name);
		void    UpdateInputsFromConstant(int constant, int name);
		void    UpdateInputsFromConstant(bool constant, int name);
		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type);
		void    UpdateFromDakota(double* variables,char** variables_descriptors,int numvariables,DataSet* parameters, double* qmu_part,int qmu_npart);


		FemModel* GetActiveFormulation();
		void* SetActiveFormulation(FemModel* femmodel);

};
#endif  /* _MODEL_H */
