/*!\file: types.h
 * \brief prototypes for types.h
 */ 

#ifndef _TYPES_H_
#define  _TYPES_H_


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"

/*Define abstract type for I/O: */
#ifdef _SERIAL_
#include <mex.h>
typedef const mxArray* ConstDataHandle;  //serially, we are reading data from a matlab array.
typedef mxArray* DataHandle;  
#else 
typedef FILE* ConstDataHandle; //in parallel, we are reading data from a file.
typedef FILE* DataHandle; 
#endif
enum param_type { STRING, INTEGER, STRINGARRAY, DOUBLE, DOUBLEVEC, DOUBLEMAT, PETSCVEC, PETSCMAT };

/*here are our abstracted types: inspired on petsc */
#if defined(ISSM_USE_64BIT_INDICES)
typedef long long IssmInt;
//#define MPIU_INT MPI_LONG_LONG_INT already define in petsc
#else
typedef int IssmInt;
//#define MPIU_INT MPI_INT already defined in petsc
#endif  

typedef double IssmDouble;
typedef bool IssmBool;


#endif //ifndef _TYPES_H_
