/*!\file:  CreateSingleNodeToElementConnectivity.cpp
 * \brief: create connectivity table
 */ 

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../shared/shared.h"
#include "../io/io.h"
#include "../include/include.h"
#include "../include/include.h"
#include "./ModelProcessorx.h"

void CreateSingleNodeToElementConnectivity(IoModel* iomodel){

	/*Intermediary*/
	int i,j;
	int vertexid;

	/*output*/
	double* connectivity=NULL;

	/*Some checks if debugging*/
	ISSMASSERT(iomodel->numberofvertices);
	ISSMASSERT(iomodel->numberofelements);
	ISSMASSERT(iomodel->elements);

	/*Allocate ouput*/
	connectivity=(double*)xcalloc(iomodel->numberofvertices,sizeof(double));

	if (strcmp(iomodel->meshtype,"2d")==0){
		for (i=0;i<iomodel->numberofelements;i++){
			for (j=0;j<3;j++){
				vertexid=(int)iomodel->elements[3*i+j];
				ISSMASSERT(vertexid-1<iomodel->numberofvertices);
				connectivity[vertexid-1]=i;
			}
		}
	}
	else{
		for (i=0;i<iomodel->numberofelements;i++){
			for (j=0;j<6;j++){
				vertexid=(int)iomodel->elements[6*i+j];
				ISSMASSERT(vertexid-1<iomodel->numberofvertices);
				connectivity[vertexid-1]=i;
			}
		}
	}
}
