#ifndef _VERTEXONGEOM_H_
#define _VERTEXONGEOM_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"

#include "../include/include.h"
#include "../include/include.h"
#include "MeshVertex.h"
#include "GeometricalVertex.h"
#include "GeometricalEdge.h"

namespace bamg {

	//classes
	class Triangles;

	class VertexOnGeom{

		public:

			MeshVertex* mv;
			double abscisse;  
			union{ 
				GeometricalVertex* gv; // if abscisse <0; 
				GeometricalEdge*   ge; // if abscisse in [0..1]
			};

			//Constructors/Destructors
			VertexOnGeom(): mv(0),abscisse(0){gv=0;} 
			VertexOnGeom(MeshVertex & m,GeometricalVertex &g) : mv(&m),abscisse(-1){gv=&g;}
			VertexOnGeom(MeshVertex & m,GeometricalEdge &g,double s) : mv(&m),abscisse(s){ge=&g;}

			//Operators
			operator MeshVertex*() const  {return mv;}
			operator GeometricalVertex * () const  {return gv;}
			operator GeometricalEdge * () const  {return ge;}
			operator const double & () const {return abscisse;}

			//Methods
			int  OnGeomVertex()const{return this? abscisse <0 :0;}
			int  OnGeomEdge() const {return this? abscisse >=0 :0;}
			int  IsRequiredVertex() {return this? ((abscisse<0 ? (gv?gv->Required():0):0 )) : 0;}
			void SetOn(){mv->onGeometry=this;mv->vint=IsVertexOnGeom;}

			//Inline methods
			void Set(const VertexOnGeom&,const Triangles &,Triangles &);  

	};

}
#endif
