/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#include "../DataSet/DataSet.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "../io/io.h"

void CreateParameters(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	int i;
	
	Parameters* parameters = NULL;
	int      numberofdofspernode;
	char**   parameteroutput=NULL;
	char*    descriptor=NULL;
	char*    tag=NULL;
	#ifdef _SERIAL_
		mxArray* pfield=NULL;
		mxArray* pfield2=NULL;
	#endif

	/*Initialize dataset: */
	parameters = new Parameters(ParametersEnum);

	if (strcmp(iomodel->meshtype,"2d")==0) parameters->AddObject(new IntParam(DimEnum,2));
	else parameters->AddObject(new IntParam(DimEnum,3));
	parameters->AddObject(new    IntParam(AnalysisTypeEnum,iomodel->analysis_type));
	parameters->AddObject(new    IntParam(SubAnalysisTypeEnum,iomodel->sub_analysis_type));
	parameters->AddObject(new StringParam(OutputFileNameEnum,iomodel->outputfilename));
	parameters->AddObject(new   BoolParam(IsHutterEnum,iomodel->ishutter));
	parameters->AddObject(new   BoolParam(IsMacAyealPattynEnum,iomodel->ismacayealpattyn));
	parameters->AddObject(new   BoolParam(IsStokesEnum,iomodel->isstokes));
	parameters->AddObject(new    IntParam(VerboseEnum,iomodel->verbose));
	parameters->AddObject(new DoubleParam(EpsResEnum,iomodel->eps_res));
	parameters->AddObject(new DoubleParam(EpsRelEnum,iomodel->eps_rel));
	parameters->AddObject(new DoubleParam(EpsAbsEnum,iomodel->eps_abs));
	parameters->AddObject(new DoubleParam(MaxNonlinearIterationsEnum,iomodel->max_nonlinear_iterations));
	parameters->AddObject(new DoubleParam(EpsVelEnum,iomodel->epsvel));
	parameters->AddObject(new DoubleParam(YtsEnum,iomodel->yts));
	parameters->AddObject(new DoubleParam(DtEnum,iomodel->dt*iomodel->yts)); //Dt is in years in iomodel
	parameters->AddObject(new DoubleParam(NdtEnum,iomodel->ndt*iomodel->yts)); //Ndt is in yeats in iomodel
	parameters->AddObject(new DoubleParam(PenaltyOffsetEnum,iomodel->penalty_offset));
	parameters->AddObject(new DoubleParam(SparsityEnum,iomodel->sparsity));
	parameters->AddObject(new   BoolParam(LowmemEnum,iomodel->lowmem));
	parameters->AddObject(new DoubleParam(ConnectivityEnum,iomodel->connectivity));
	parameters->AddObject(new DoubleParam(BetaEnum,iomodel->beta));
	parameters->AddObject(new DoubleParam(MeltingPointEnum,iomodel->meltingpoint));
	parameters->AddObject(new DoubleParam(LatentHeatEnum,iomodel->latentheat));
	parameters->AddObject(new DoubleParam(HeatCapacityEnum,iomodel->heatcapacity));
	parameters->AddObject(new   BoolParam(ArtDiffEnum,iomodel->artdiff));
	parameters->AddObject(new DoubleParam(PenaltyMeltingEnum,iomodel->penalty_melting));
	parameters->AddObject(new    IntParam(MinThermalConstraintsEnum,iomodel->min_thermal_constraints));
	parameters->AddObject(new    IntParam(StabilizeConstraintsEnum,iomodel->stabilize_constraints));
	parameters->AddObject(new DoubleParam(StokesReconditioningEnum,iomodel->stokesreconditioning));
	parameters->AddObject(new DoubleParam(ViscosityOvershootEnum,iomodel->viscosity_overshoot));
	parameters->AddObject(new   BoolParam(WaitOnLockEnum,iomodel->waitonlock));
	parameters->AddObject(new StringParam(SolverStringEnum,iomodel->solverstring));
	parameters->AddObject(new    IntParam(NumberOfVerticesEnum,iomodel->numberofvertices));
	parameters->AddObject(new    IntParam(NumberOfElementsEnum,iomodel->numberofelements));

	/*Deal with more complex parameters*/
	if (
				iomodel->analysis_type==Prognostic2AnalysisEnum ||
				iomodel->analysis_type==Balancedthickness2AnalysisEnum
				)
		parameters->AddObject(new    IntParam(NumberOfNodesEnum,3*iomodel->numberofelements));
	else parameters->AddObject(new    IntParam(NumberOfNodesEnum,iomodel->numberofvertices));

	DistributeNumDofs(&numberofdofspernode,iomodel->analysis_type,iomodel->sub_analysis_type);
	parameters->AddObject(new    IntParam(NumberOfDofsPerNodeEnum,numberofdofspernode));

	IoModelFetchData(&iomodel->riftinfo,&iomodel->numrifts,NULL,iomodel_handle,"riftinfo");
	parameters->AddObject(new    IntParam(NumRiftsEnum,iomodel->numrifts));
	xfree((void**)&iomodel->riftinfo); 

	parameters->AddObject(new    IntParam(NumOutputEnum,iomodel->numoutput));
	if(iomodel->numoutput){
		parameteroutput=(char**)xmalloc(iomodel->numoutput*sizeof(char*));

		#ifdef _SERIAL_
		pfield=mxGetField(iomodel_handle,0,"parameteroutput");
		for(i=0;i<iomodel->numoutput;i++){
			pfield2=mxGetCell(pfield,i);
			FetchData(&descriptor,pfield2);
			parameteroutput[i]=descriptor;
		}
		#else
		tag=(char*)xmalloc((strlen("parameteroutput_i")+1)*sizeof(char));
		for(i=0;i<iomodel->numoutput;i++){
			sprintf(tag,"%s%i","parameteroutput_",i);
			IoModelFetchData(&descriptor,iomodel_handle,tag);
			parameteroutput[i]=descriptor;
		}
		#endif

		/*Ok, we have all the parameter output  descriptors. Build a parameter with it: */
		parameters->AddObject(new StringArrayParam(ParameterOutputEnum,parameteroutput,iomodel->numoutput));
	}

	/*All our datasets are already ordered by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	parameters->Presort();

	/*Free data: */
	xfree((void**)&tag);
	for(i=0;i<iomodel->numoutput;i++){
		char* descriptor=parameteroutput[i];
		xfree((void**)&descriptor);
	}
	xfree((void**)&parameteroutput);

	/*Assign output pointer: */
	*pparameters=parameters;
}
