/*\file SplitSolutionVector.c
 *\brief: average field throfieldh thickness
 */

#include "./SplitSolutionVector.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int i,j;

	/*input datasets: */
	double* vector=NULL;
	int dummy=NULL;
	int numberofnodes;
	int numberofdofspernode;

	/*Boot module: */
	MODULEBOOT();

	/*Input datasets: */
	FetchData(&vector,&dummy,VECTOR);
	FetchData(&numberofnodes,NUMBEROFNODES);
	FetchData(&numberofdofspernode,NUMBEROFDOFSPERNODE);

	/*Now, loop on the number of outputs requested: */
	for(i=0;i<numberofdofspernode;i++){
		double*  component=(double*)xmalloc(numberofnodes*sizeof(double));
		for (j=0;j<numberofnodes;j++) component[i]=vector[j*numberofdofs+i];


		/*write output : */
		WriteData(&plhs[i],component,numberofnodes);

		/*Free ressources:*/
		xfree((void**)&component);
	}

	/*Free ressources:*/
	xfree((void**)&vector);
	
	/*end module: */
	MODULEEND();

}

void SplitSolutionVectorUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [vectorx,vectory,...] = %s(vector,numberofnodes,numberofdofpernode);\n",__FUNCT__);
	_printf_("\n");
}
