#!/bin/bash
#Synchronize Matlab and C Enums
#Create a matlab file using the same Enum as in EnumDefinitions.cpp
#and move the file to src/m/enum

#first remove all existing enum
rm $ISSM_DIR/src/m/enum/*.m

echo "Synchronizing Matlab's Enums..."
#Get all lines of EnumDefinitions2.h which hold Enum | remove all comas | add line number in the first column > put everything in file temp
cat EnumDefinitions.h | grep "[Aa-Zz]Enum" | grep -v StringAsEnum | sed -e "s/,//g" | awk '{ printf "%s %s\n", NR, $0 }' > temp

#Build header of AnalysisTypeFromEnum.m{{{
cat <<END > AnalysisTypeFromEnum.m
function string=AnalysisTypeFromEnum(enum)
%ANALYSISASENUM - get analysis type from Enum
%
%   WARNING: DO NOT MODIFY THIS FILE
%            this file has been automatically generated by src/c/SynchronizeMatlabEnum
%            Please read src/c/README for more information
%
%   Usage:
%      string=AnalysisTypeFromEnum(enum)

%initialize output
string='not found';
END
#}}}

#get number of lines in temp
NUMBEROFLINES=$(wc -l temp | awk '{printf("%s",$1);}');

# go through the lines of temp
for i in `seq 1 1 $NUMBEROFLINES`; do

	#Get name and enum of the line i
	NAME=$(cat temp | grep "^[ ]*$i " | awk '{printf("%s",$2);}');
	ENUM=$i;
	#offset Enum by one (Enum begins with 0 and not 1!)
	let ENUM=$ENUM-1

	#print info {{{
	if [ $i -lt 10 ]
	then
		printf "\r                                                                      "
		printf "\r  $i/$NUMBEROFLINES writing file "$NAME".m..."
	else
		if [ $i -lt 100 ]
		then
			printf "\r                                                                      "
			printf "\r $i/$NUMBEROFLINES writing file "$NAME".m..."
		else
			printf "\r                                                                      "
			printf "\r$i/$NUMBEROFLINES writing file "$NAME".m..."
		fi
	fi
	#}}}
	#Add case to matlabenum file{{{
	cat <<END > $(echo $NAME".m")
function macro=$(echo $NAME)()
%$(echo `echo $NAME | sed -e "s/[a-z]/\U&/g"`) - Enum of $(echo `echo $NAME | sed -e "s/Enum//"`)
%
%   WARNING: DO NOT MODIFY THIS FILE
%            this file has been automatically generated by src/c/SynchronizeMatlabEnum
%            Please read src/c/README for more information
%
%   Usage:
%      macro=$NAME()

macro=$ENUM;
END
#}}}
#Add case to AnalysisTypeFromEnum file{{{
	if [ $(echo $NAME | grep AnalysisEnum) ]
	then
		cat <<END >> AnalysisTypeFromEnum.m

if enum==$NAME(),
	string='$(echo `echo $NAME | sed -e "s/AnalysisEnum//g" | awk {'print tolower($_)'}`)';
end
END
	fi
#}}}

	#move file to m/enum
	mv $NAME".m" $ISSM_DIR"/src/m/enum/"

done

#Footer of AnalysisTypeFromEnum.m{{{
cat <<END >> AnalysisTypeFromEnum.m

%check that an analysis type has been found for enum
if strcmp(string,'not found'),
	error(['AnalysisTypeFromEnum error message: enum ' num2str(enum) ' not supported!']);
end
END
#}}}

#clean up{{{
mv AnalysisTypeFromEnum.m $ISSM_DIR/src/m/enum/
rm temp
#}}}
#print info{{{
printf "\r                                                                      "
printf "\rdone!\n"
#}}}
