##### http://autoconf-archive.cryp.to/ax_cflags_warn_all.html
#
# SYNOPSIS
#
#   AX_CFLAGS_WARN_ALL [(shellvar [,default, [A/NA]])]
#
# DESCRIPTION
#
#   Try to find a compiler option that enables most reasonable
#   warnings. This macro is directly derived from VL_PROG_CC_WARNINGS
#   which is split up into two AX_CFLAGS_WARN_ALL and
#   AX_CFLAGS_WARN_ALL_ANSI
#
#   For the GNU CC compiler it will be -Wall (and -ansi -pedantic) The
#   result is added to the shellvar being CFLAGS by default.
#
#   Currently this macro knows about GCC, Solaris C compiler, Digital
#   Unix C compiler, C for AIX Compiler, HP-UX C compiler, IRIX C
#   compiler, NEC SX-5 (Super-UX 10) C compiler, and Cray J90 (Unicos
#   10.0.0.8) C compiler.
#
#    - $1 shell-variable-to-add-to : CFLAGS
#    - $2 add-value-if-not-found : nothing
#    - $3 action-if-found : add value to shellvariable
#    - $4 action-if-not-found : nothing
#
# LAST MODIFICATION
#
#   2006-12-12
#
# COPYLEFT
#
#   Copyright (c) 2006 Guido U. Draheim <guidod@gmx.de>
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License as
#   published by the Free Software Foundation; either version 2 of the
#   License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#   02111-1307, USA.
#
#   As a special exception, the respective Autoconf Macro's copyright
#   owner gives unlimited permission to copy, distribute and modify the
#   configure scripts that are the output of Autoconf when processing
#   the Macro. You need not follow the terms of the GNU General Public
#   License when using or distributing such scripts, even though
#   portions of the text of the Macro appear in them. The GNU General
#   Public License (GPL) does govern all other use of the material that
#   constitutes the Autoconf Macro.
#
#   This special exception to the GPL applies to versions of the
#   Autoconf Macro released by the Autoconf Macro Archive. When you
#   make and distribute a modified version of the Autoconf Macro, you
#   may extend this special exception to the GPL to apply to your
#   modified version as well.

AC_DEFUN([AX_CFLAGS_WARN_ALL],[dnl
AS_VAR_PUSHDEF([FLAGS],[CFLAGS])dnl
AS_VAR_PUSHDEF([VAR],[ac_cv_cflags_warn_all])dnl
AC_CACHE_CHECK([m4_ifval($1,$1,FLAGS) for maximum warnings],
VAR,[VAR="no, unknown"
 AC_LANG_SAVE
 AC_LANG_C
 ac_save_[]FLAGS="$[]FLAGS"
for ac_arg dnl
in "-pedantic  % -Wall"       dnl   GCC
   "-xstrconst % -v"          dnl Solaris C
   "-std1      % -verbose -w0 -warnprotos" dnl Digital Unix
   "-qlanglvl=ansi % -qsrcmsg -qinfo=all:noppt:noppc:noobs:nocnd" dnl AIX
   "-ansi -ansiE % -fullwarn" dnl IRIX
   "+ESlit     % +w1"         dnl HP-UX C
   "-Xc        % -pvctl[,]fullmsg" dnl NEC SX-5 (Super-UX 10)
   "-h conform % -h msglevel 2" dnl Cray C (Unicos)
   #
do FLAGS="$ac_save_[]FLAGS "`echo $ac_arg | sed -e 's,%%.*,,' -e 's,%,,'`
   AC_TRY_COMPILE([],[return 0;],
   [VAR=`echo $ac_arg | sed -e 's,.*% *,,'` ; break])
done
 FLAGS="$ac_save_[]FLAGS"
 AC_LANG_RESTORE
])
case ".$VAR" in
     .ok|.ok,*) m4_ifvaln($3,$3) ;;
   .|.no|.no,*) m4_ifvaln($4,$4,[m4_ifval($2,[
        AC_RUN_LOG([: m4_ifval($1,$1,FLAGS)="$m4_ifval($1,$1,FLAGS) $2"])
                      m4_ifval($1,$1,FLAGS)="$m4_ifval($1,$1,FLAGS) $2"])]) ;;
   *) m4_ifvaln($3,$3,[
   if echo " $[]m4_ifval($1,$1,FLAGS) " | grep " $VAR " 2>&1 >/dev/null
   then AC_RUN_LOG([: m4_ifval($1,$1,FLAGS) does contain $VAR])
   else AC_RUN_LOG([: m4_ifval($1,$1,FLAGS)="$m4_ifval($1,$1,FLAGS) $VAR"])
                      m4_ifval($1,$1,FLAGS)="$m4_ifval($1,$1,FLAGS) $VAR"
   fi ]) ;;
esac
AS_VAR_POPDEF([VAR])dnl
AS_VAR_POPDEF([FLAGS])dnl
])

dnl the only difference - the LANG selection... and the default FLAGS

AC_DEFUN([AX_CXXFLAGS_WARN_ALL],[dnl
AS_VAR_PUSHDEF([FLAGS],[CXXFLAGS])dnl
AS_VAR_PUSHDEF([VAR],[ac_cv_cxxflags_warn_all])dnl
AC_CACHE_CHECK([m4_ifval($1,$1,FLAGS) for maximum warnings],
VAR,[VAR="no, unknown"
 AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 ac_save_[]FLAGS="$[]FLAGS"
for ac_arg dnl
in "-pedantic  % -Wall"       dnl   GCC
   "-xstrconst % -v"          dnl Solaris C
   "-std1      % -verbose -w0 -warnprotos" dnl Digital Unix
   "-qlanglvl=ansi % -qsrcmsg -qinfo=all:noppt:noppc:noobs:nocnd" dnl AIX
   "-ansi -ansiE % -fullwarn" dnl IRIX
   "+ESlit     % +w1"         dnl HP-UX C
   "-Xc        % -pvctl[,]fullmsg" dnl NEC SX-5 (Super-UX 10)
   "-h conform % -h msglevel 2" dnl Cray C (Unicos)
   #
do FLAGS="$ac_save_[]FLAGS "`echo $ac_arg | sed -e 's,%%.*,,' -e 's,%,,'`
   AC_TRY_COMPILE([],[return 0;],
   [VAR=`echo $ac_arg | sed -e 's,.*% *,,'` ; break])
done
 FLAGS="$ac_save_[]FLAGS"
 AC_LANG_RESTORE
])
case ".$VAR" in
     .ok|.ok,*) m4_ifvaln($3,$3) ;;
   .|.no|.no,*) m4_ifvaln($4,$4,[m4_ifval($2,[
        AC_RUN_LOG([: m4_ifval($1,$1,FLAGS)="$m4_ifval($1,$1,FLAGS) $2"])
                      m4_ifval($1,$1,FLAGS)="$m4_ifval($1,$1,FLAGS) $2"])]) ;;
   *) m4_ifvaln($3,$3,[
   if echo " $[]m4_ifval($1,$1,FLAGS) " | grep " $VAR " 2>&1 >/dev/null
   then AC_RUN_LOG([: m4_ifval($1,$1,FLAGS) does contain $VAR])
   else AC_RUN_LOG([: m4_ifval($1,$1,FLAGS)="$m4_ifval($1,$1,FLAGS) $VAR"])
                      m4_ifval($1,$1,FLAGS)="$m4_ifval($1,$1,FLAGS) $VAR"
   fi ]) ;;
esac
AS_VAR_POPDEF([VAR])dnl
AS_VAR_POPDEF([FLAGS])dnl
])

dnl  implementation tactics:
dnl   the for-argument contains a list of options. The first part of
dnl   these does only exist to detect the compiler - usually it is
dnl   a global option to enable -ansi or -extrawarnings. All other
dnl   compilers will fail about it. That was needed since a lot of
dnl   compilers will give false positives for some option-syntax
dnl   like -Woption or -Xoption as they think of it is a pass-through
dnl   to later compile stages or something. The "%" is used as a
dnl   delimimiter. A non-option comment can be given after "%%" marks
dnl   which will be shown but not added to the respective C/CXXFLAGS.








dnl matlabdir.m4 --- define Matlab directory names.
dnl
dnl Copyright (C) 2002, 2003 Ralph Schleicher
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:

# AX_MATLAB_DIR
# -------------
# Define Matlab directory names.
AC_DEFUN([AX_MATLAB_DIR],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_MATLAB_VERSION])
AC_REQUIRE([AC_CANONICAL_HOST])
ax_matlab_dir="\${datadir}/matlab"
AC_ARG_WITH([matlab-dir], AC_HELP_STRING([--with-matlab-dir=ARG], [use ARG as the top-level installation directory for Matlab files [[$(datadir)/matlab]]]),
[case $withval in
  yes | no)
    AC_MSG_ERROR([invalid value '$withval' for --with-matlab-dir])
    ;;
  *)
    ax_matlab_dir=$withval
    ;;
esac])
AC_MSG_CHECKING([for top-level installation directory for Matlab files])
AC_MSG_RESULT([$ax_matlab_dir])
matlabdir=$ax_matlab_dir
AC_SUBST([matlabdir])
matlabverdir="\${matlabdir}/$MATLAB_VERSION"
AC_SUBST([matlabverdir])
matlabarchdir="\${matlabverdir}/$host"
AC_SUBST([matlabarchdir])
matlabprivatedir="\${matlabdir}/private"
AC_SUBST([matlabprivatedir])
matlabprivateverdir="\${matlabverdir}/private"
AC_SUBST([matlabprivateverdir])
matlabprivatearchdir="\${matlabarchdir}/private"
AC_SUBST([matlabprivatearchdir])
])

dnl matlabdir.m4 ends here

dnl matlabver.m4 --- check for Matlab version number.
dnl
dnl Copyright (C) 2000--2003 Ralph Schleicher
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:

# AX_MATLAB_VERSION
# -----------------
# Check for Matlab version number.
AC_DEFUN([AX_MATLAB_VERSION],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AC_PROG_CC])
AC_REQUIRE([AX_MATLAB])
AC_CACHE_CHECK([for Matlab version], [ax_cv_matlab_version],
[if test "${MATLAB_VERSION+set}" = set ; then
    ax_cv_matlab_version=$MATLAB_VERSION
else
    ax_cv_matlab_version=
    # Loop over all known architectures.  The final dot covers
    # Matlab R11 and Matlab V4 for Windows.
    for ax_arch in alpha glnxa64 glnx86 hp700 hpux ibm_rs sgi sol2 win32 mac maci . ; do
        for ax_exec_name in matlab$EXEEXT MATLAB ; do
		ax_matlab_exec=$MATLAB/bin/$ax_arch/${ax_exec_name}
		if test -f $ax_matlab_exec ; then
	    		# For Matlab R12, the version number is stored in a
	    		# shared library.
	    		ax_matlab_exec_2=`find $MATLAB/bin/$ax_arch -type f -name libmwservices\* -print 2> /dev/null`
	    		if test -n "$ax_matlab_exec_2" ; then
				ax_cv_matlab_version=`strings $ax_matlab_exec_2 2> /dev/null | egrep '^\|build_version_\|@<:@0-9@:>@+\.@<:@0-9@:>@+\.@<:@0-9@:>@+\.@<:@0-9@:>@+' | head -1 | sed 's/^|build_version_|\(@<:@0-9@:>@*\.@<:@0-9@:>@*\).*/\1/'`
				if test -n "$ax_cv_matlab_version" ; then
		    			break
				fi
	    		fi
	    		# For Matlab R11 and Matlab V4, the version number
	    		# is stored in the executable program.
	    		ax_cv_matlab_version=`strings $ax_matlab_exec 2> /dev/null | egrep '^@<:@0-9@:>@+\.@<:@0-9@:>@+\.@<:@0-9@:>@+\.@<:@0-9@:>@+' | head -1 | sed 's/^\(@<:@0-9@:>@*\.@<:@0-9@:>@*\).*/\1/'`
	    		if test -n "$ax_cv_matlab_version" ; then
				break
	    		fi
				
				# For Matlab R2008 and more, the version number is stored in bin/util/mex/version.txt 
	    		ax_cv_matlab_version=`cat $MATLAB/bin/util/mex/version.txt`
	    		if test -n "$ax_cv_matlab_version" ; then
				break
	    		fi

		fi
    	done
	if test -n "$ax_cv_matlab_version" ; then
		break
	fi
    done
    if test -z "$ax_cv_matlab_version" ; then
	ax_cv_matlab_version="not found"
    fi
fi])
case $ax_cv_matlab_version in
  @<:@1-9@:>@.@<:@0-9@:>@ | @<:@1-9@:>@@<:@0-9@:>@.@<:@0-9@:>@)
    MATLAB_VERSION=$ax_cv_matlab_version
    MATLAB_MAJOR=`echo $MATLAB_VERSION | sed -e 's/^\(@<:@0-9@:>@*\)\.@<:@0-9@:>@*.*/\1/'`
    MATLAB_MINOR=`echo $MATLAB_VERSION | sed -e 's/^@<:@0-9@:>@*\.\(@<:@0-9@:>@*\).*/\1/'`
    ;;
  R2009a)
	MATLAB_VERSION=R2009a
    MATLAB_MAJOR=7
    MATLAB_MINOR=8
	;;
	R2008a)
	MATLAB_VERSION=R2008a
    MATLAB_MAJOR=7
    MATLAB_MINOR=6
	;;

  *)
    if test x$ax_enable_matlab = xyes ; then
	AC_MSG_ERROR([can not determine Matlab version number])
    fi
    MATLAB_VERSION=
    MATLAB_MAJOR=
    MATLAB_MINOR=
    ;;
esac
AC_SUBST([MATLAB_VERSION])
AC_SUBST([MATLAB_MAJOR])
AC_SUBST([MATLAB_MINOR])
if test x$MATLAB_VERSION != x ; then
    AC_DEFINE_UNQUOTED([MATLAB_MAJOR], [$MATLAB_MAJOR], [Define to the Matlab major version number.])
    AC_DEFINE_UNQUOTED([MATLAB_MINOR], [$MATLAB_MINOR], [Define to the Matlab minor version number.])
fi
])

# AX_REQUIRE_MATLAB_VERSION([MINIMUM-VERSION])
# --------------------------------------------
# Check if Matlab version number is sufficient.
AC_DEFUN([AX_REQUIRE_MATLAB_VERSION],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_MATLAB_VERSION])
if test x$MATLAB_VERSION = x ; then
    AC_MSG_ERROR([can not determine Matlab version number])
fi
m4_if([$1], [], [],
[AC_MSG_CHECKING([if Matlab version is sufficient])
ax_version='$1'
case $ax_version in
  @<:@1-9@:>@ | @<:@1-9@:>@@<:@0-9@:>@)
    ax_major=$ax_version
    ax_minor=''
    ;;
  @<:@1-9@:>@.@<:@0-9@:>@ | @<:@1-9@:>@@<:@0-9@:>@.@<:@0-9@:>@)
    ax_major=`echo $ax_version | sed 's/^\(@<:@0-9@:>@*\)\.@<:@0-9@:>@*.*/\1/'`
    ax_minor=`echo $ax_version | sed 's/^@<:@0-9@:>@*\.\(@<:@0-9@:>@*\).*/\1/'`
    ;;
  *)
    AC_MSG_RESULT([failure])
    AC_MSG_NOTICE([report this bug to the responsible package maintainer])
    AC_MSG_ERROR([invalid Matlab version number argument to AX_REQUIRE_MATLAB_VERSION])
    ;;
esac
ax_ans=yes
if test $MATLAB_MAJOR -eq $ax_major ; then
    if test x$ax_minor != x && test $MATLAB_MINOR -lt $ax_minor ; then
	ax_ans=no
    fi
elif test $MATLAB_MAJOR -lt $ax_major ; then
    ax_ans=no
fi
AC_MSG_RESULT([$ax_ans])
if test x$ax_ans = xno ; then
    AC_MSG_ERROR([require Matlab version $ax_version or above])
fi])
])

dnl matlabver.m4 ends here

dnl matlab.m4 --- check for Matlab.
dnl
dnl Copyright (C) 2000--2003 Ralph Schleicher
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:

# AX_MATLAB
# ---------
# Check for Matlab.
AC_DEFUN([AX_MATLAB],
[dnl
AC_PREREQ([2.50])
ax_enable_matlab=
AC_ARG_WITH([matlab-dir], AC_HELP_STRING([--with-matlab-dir=ARG], [check for Matlab [[yes]]]),
[case $withval in
  yes | no)
    # Explicitly enable or disable Matlab but determine
    # Matlab prefix automatically.
    ax_enable_matlab=$withval
    ;;
  *)
    # Enable Matlab and use ARG as the Matlab prefix.
    # ARG must be an existing directory.
    ax_enable_matlab=yes
    MATLAB=`cd "${withval-/}" > /dev/null 2>&1 && pwd`
    if test -z "$MATLAB" ; then
	AC_MSG_ERROR([invalid value '$withval' for --with-matlab])
    fi
    ;;
esac])
if test x$ax_enable_matlab != xno ; then
AC_CACHE_CHECK([for Matlab prefix], [ax_cv_matlab],
[if test "${MATLAB+set}" = set ; then
    ax_cv_matlab=`cd "${MATLAB-/}" > /dev/null 2>&1 && pwd`
else
    ax_cv_matlab=
    IFS=${IFS= 	} ; ax_ifs=$IFS ; IFS=:
    for ax_dir in ${PATH-/opt/bin:/usr/local/bin:/usr/bin:/bin} ; do
	if test -z "$ax_dir" ; then
	    ax_dir=.
	fi
	if test -x "$ax_dir/matlab" ; then
	    ax_dir=`echo "$ax_dir" | sed 's,/bin$,,'`
	    # Directory sanity check.
	    ax_cv_matlab=`cd "${ax_dir-/}" > /dev/null 2>&1 && pwd`
	    if test -n "$ax_cv_matlab" ; then
		break
	    fi
	fi
    done
    IFS=$ax_ifs
fi
if test -z "$ax_cv_matlab" ; then
    ax_cv_matlab="not found"
fi])
if test "$ax_cv_matlab" = "not found" ; then
    unset MATLAB
else
    # Strip trailing dashes.
    MATLAB=`echo "$ax_cv_matlab" | sed 's,/*$,,'`
fi
AC_MSG_CHECKING([whether to enable Matlab support])
if test x$ax_enable_matlab != xno ; then
    if test "${MATLAB+set}" = set && test -d "$MATLAB/extern/include" ; then
	ax_enable_matlab=yes
    elif test x$ax_enable_matlab = x ; then
	ax_enable_matlab=no
    else
	# Fail if Matlab was explicitly enabled.
	AC_MSG_RESULT([failure])
	AC_MSG_ERROR([check your Matlab setup])
    fi
fi
AC_MSG_RESULT([$ax_enable_matlab])
if test x$ax_enable_matlab = xyes ; then
    AC_DEFINE([HAVE_MATLAB], [1], [Define if you have Matlab.])
fi
fi
AC_SUBST([MATLAB])
])

# AX_REQUIRE_MATLAB
# -----------------
# Like AX_MATLAB but fail if Matlab support is disabled.
AC_DEFUN([AX_REQUIRE_MATLAB],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_MATLAB])
if test x$ax_enable_matlab = xno ; then
    AC_MSG_ERROR([can not enable Matlab support])
fi
])

# AX_MATLAB_CONDITIONAL
# ---------------------
# Define Matlab conditional for GNU Automake.
AC_DEFUN([AX_MATLAB_CONDITIONAL],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_MATLAB])
AM_CONDITIONAL([MATLAB], [test x$ax_enable_matlab = xyes])
])

dnl matlab.m4 ends here

dnl mex.m4 --- check for mex(1) command.
dnl
dnl Copyright (C) 2000--2003 Ralph Schleicher
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:

# AX_PATH_MEX
# -----------
# Check for mex(1) command.
AC_DEFUN([AX_PATH_MEX],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_MATLAB])
AC_REQUIRE([AX_MEX_OPTIONS])
AC_REQUIRE([AC_CANONICAL_HOST])
if test "${MEX+set}" != set ; then
    case $host_os in
      *cygwin* | *mingw32*)
	ax_list='mextool mex mex.bat'
	;;
      *)
	ax_list='mex'
	;;
    esac
    AC_PATH_PROGS([MEX], $ax_list, mex, $MATLAB/bin:$PATH)
fi
AC_SUBST([MEX])
if test "${MEXFLAGS+set}" != set ; then
    MEXFLAGS=-O
fi
AC_SUBST([MEXFLAGS])
if test "${MEXLDADD+set}" != set ; then
    MEXLDADD=
fi
AC_SUBST([MEXLDADD])
])

dnl mex.m4 ends here

dnl mexopt.m4 --- check for MEX options file.
dnl
dnl Copyright (C) 2001--2003 Ralph Schleicher
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:

# AX_MEX_OPTIONS
# --------------
# Check for MEX options file.
AC_DEFUN([AX_MEX_OPTIONS],
[dnl
AC_PREREQ([2.50])
mex_options=yes
AC_ARG_WITH([mex-options], AC_HELP_STRING([--with-mex-options=ARG], [use MEX options file ARG [[standard]]]),
[mex_options=$withval])
AC_MSG_CHECKING([for MEX options file handling])
case $mex_options in
  yes)
    AC_MSG_RESULT([standard])
    mexopts_sh=
    ;;
  no)
    AC_MSG_RESULT([disabled])
    mexopts_sh=$ac_aux_dir/noopts.sh
    ;;
  *)
    AC_MSG_RESULT([enabled])
    mexopts_sh=$mex_options
    ;;
esac
if test -n "$mexopts_sh" ; then
    AC_MSG_CHECKING([whether MEX options file exists])
    if test -f "$mexopts_sh" ; then
	AC_MSG_RESULT([yes])
	# Canonicalize file name.
	mexopts_sh_dir=`echo "$mexopts_sh" | sed 's,[[^/]]*$,,'`
	mexopts_sh_dir=`cd "${mexopts_sh_dir-.}" && pwd`
	mexopts_sh_name=`echo "$mexopts_sh" | sed 's,.*/,,'`
	mexopts_sh="$mexopts_sh_dir/$mexopts_sh_name"
    else
	AC_MSG_RESULT([no])
	AC_MSG_ERROR([$mexopts_sh: no such file])
    fi
    MEXOPTS="-f $mexopts_sh"
else
    MEXOPTS=
fi
AC_SUBST([mexopts_sh])
AC_SUBST([MEXOPTS])
])

dnl mexopt.m4 ends here

dnl mexext.m4 --- check for MEX-file suffix.
dnl
dnl Copyright (C) 2000--2003 Ralph Schleicher
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:

# AX_MEXEXT
# ---------
# Check for MEX-file suffix.
AC_DEFUN([AX_MEXEXT],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_PATH_MEX])
AC_CACHE_CHECK([for MEX-file suffix], [ax_cv_mexext],
[if test "${MEXEXT+set}" = set ; then
    ax_cv_mexext="$MEXEXT"
else
    if test -x ${MATLAB}/bin/mexext ; then
      ax_cv_mexext=`${MATLAB}/bin/mexext`
    fi
fi
if test "x${ax_cv_mexext}" = "x" ; then
    echo 'mexFunction () {}' > ax_c_test.c
    $MEX $MEXOPTS $MEXFLAGS -output ax_c_test ax_c_test.c $MEXLDADD 2> /dev/null 1>&2
    if test -f ax_c_test.dll ; then
	ax_cv_mexext=dll
    elif test -f ax_c_test.mex ; then
	ax_cv_mexext=mex
    elif test -f ax_c_test.mexaxp ; then
	ax_cv_mexext=mexaxp
    elif test -f ax_c_test.mexglx ; then
	ax_cv_mexext=mexglx
    elif test -f ax_c_test.mexa64 ; then
	ax_cv_mexext=mexa64
    elif test -f ax_c_test.mexmac ; then
	ax_cv_mexext=mexmac
    elif test -f ax_c_test.mexmaci ; then
	ax_cv_mexext=mexmaci
    elif test -f ax_c_test.mexhp7 ; then
	ax_cv_mexext=mexhp7
    elif test -f ax_c_test.mexhpux ; then
	ax_cv_mexext=mexhpux
    elif test -f ax_c_test.mexrs6 ; then
	ax_cv_mexext=mexrs6
    elif test -f ax_c_test.mexsg ; then
	ax_cv_mexext=mexsg
    elif test -f ax_c_test.mexsol ; then
	ax_cv_mexext=mexsol
    elif test -f ax_c_test.mexs64 ; then
	ax_cv_mexext=mexs64
    elif test -f ax_c_test.mexw32 ; then
	ax_cv_mexext=mexw32
    elif test -f ax_c_test.mexw64 ; then
	ax_cv_mexext=mexw64
    else
	ax_cv_mexext=unknown
    fi
    rm -f ax_c_test*
fi])
MEXEXT="$ax_cv_mexext"
AC_SUBST([MEXEXT])
])

# AX_DOT_MEXEXT
# -------------
# Check for MEX-file suffix with leading dot.
AC_DEFUN([AX_DOT_MEXEXT],
[dnl
AC_REQUIRE([AX_MEXEXT])
case $MEXEXT in
  .*)
    ;;
  unknown)
    ;;
  *)
    if test -n "$MEXEXT" ; then
	MEXEXT=.$MEXEXT
	AC_MSG_RESULT([setting MEX-file suffix to $MEXEXT])
	AC_SUBST([MEXEXT])
    fi
    ;;
esac
])

dnl mexext.m4 ends here

dnl ccmex.m4 --- check how to compile c programs using mex
dnl
dnl Copyright (C) 2007 Duncan Brown
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:    

# AX_CC_MEX
# ------------
# Check for the flags needed to build a file with mex
AC_DEFUN([AX_CC_MEX],
[dnl
AC_REQUIRE([AX_PATH_MEX])
AC_REQUIRE([AX_DOT_MEXEXT])
AC_LANG([C])

dnl Source code for the test matlab C program
ac_mex_source='[#include "mex.h"
void mexFunction( int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[]) { return; }]'

dnl Check that the test C program can be compiled with mex
ac_exeext_save=$ac_exeext
ac_exeext=$MEXEXT
ac_link_save=$ac_link
ac_link='$MEX $MEXOPTS $MEXFLAGS -output conftest$ac_exeext conftest.$ac_ext $MEXLDADD >&AS_MESSAGE_LOG_FD'
AC_MSG_CHECKING([if mex works])
AC_LINK_IFELSE([AC_LANG_SOURCE($ac_mex_source)],
[AC_MSG_RESULT([yes])],
[AC_MSG_RESULT([no])])

dnl Try to figure out how mex compiles a C program
ax_cv_mex_version=
ac_cv_mex_cppflags=
ac_cv_mex_includes=
ac_cv_mex_cflags=
ac_cv_mex_libs=
ac_cv_mex_ldflags=

dnl Variable that will be subsituted
MEX_VERSION_C=
MEX_LDFLAGS=
MEX_CPPFLAGS=
MEX_INCLUDES=
MEX_CFLAGS=
MEX_LIBS=
MEX_LDFLAGS=

AC_MSG_CHECKING([if mex -n works])
ac_save_MEXOPTS=$MEXOPTS
MEXOPTS="-n $MEXOPTS"
AC_LANG_CONFTEST([AC_LANG_SOURCE($ac_mex_source)])
(eval echo $as_me:__oline__: \"$ac_link\") >&AS_MESSAGE_LOG_FD
ac_cv_mex_n_output=`eval $ac_link AS_MESSAGE_LOG_FD>&1 2>&1`
ac_cv_mex_n_result=$?
echo "$ac_cv_mex_n_output" >&AS_MESSAGE_LOG_FD
MEXOPTS=$ac_save_MEXOPTS
rm -f conftest*
ac_exeext=$ac_exeext_save
ac_link=$ac_link_save

if test $ac_cv_mex_n_result -eq 0 ; then
  ac_cv_mex_working=yes
  AC_MSG_RESULT([$ac_cv_mex_working])

  dnl Save positional arguments (if any)
  ac_save_positional="$[@]"

  set X $ac_cv_mex_n_output
  while test $[@%:@] != 1; do
    shift
      ac_arg=$[1]
      case $ac_arg in
        *mexversion.c)
          ax_cv_mex_version=$ac_arg
          ;;
        -pthread)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cppflags, ,
            ac_cv_mex_cppflags="$ac_cv_mex_cppflags $ac_arg")
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cflags, ,
            ac_cv_mex_cflags="$ac_cv_mex_cflags $ac_arg")
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_ldflags, ,
            ac_cv_mex_ldflags="$ac_cv_mex_ldflags $ac_arg")
          ;;
        -mt)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cppflags, ,
            ac_cv_mex_cppflags="$ac_cv_mex_cppflags $ac_arg")
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cflags, ,
            ac_cv_mex_cflags="$ac_cv_mex_cflags $ac_arg")
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_ldflags, ,
            ac_cv_mex_ldflags="$ac_cv_mex_ldflags $ac_arg")
          ;;
        -ansi)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cppflags, ,
            ac_cv_mex_cppflags="$ac_cv_mex_cppflags $ac_arg")
          ;;
        -D*)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cppflags, ,
            ac_cv_mex_cppflags="$ac_cv_mex_cppflags $ac_arg")
          ;;
        -I*)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_includes, ,
            ac_cv_mex_includes="$ac_cv_mex_includes $ac_arg")
          ;;
        -f* | -O* | -xO* | -xlibmil )
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_cflags, ,
            ac_cv_mex_cflags="$ac_cv_mex_cflags $ac_arg")
          ;;
        -l*)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_libs, ,
            ac_cv_mex_libs="$ac_cv_mex_libs $ac_arg")
          ;;
        -L)
          # When -L is seen by itself, it takes an argument
          # We remove the space between option and argument and re-iterate
          # unless we find an empty arg or a new option (starting with -)
          case $[2] in
             "" | -*);;
             *)
             ac_arg="$ac_arg$[2]"
             shift; shift
             set X $ac_arg "$[@]"
             ;;
           esac
           ;;
        -L* | -Wl,* | -shared | -bundle | -G)
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_ldflags, ,
            ac_cv_mex_ldflags="$ac_cv_mex_ldflags $ac_arg")
          ;;
        -undefined)
          # the darwin linker undefined option takes and argument
          ac_arg="$ac_arg $[2]"
          shift
          _AC_LIST_MEMBER_IF($ac_arg, $ac_cv_mex_ldflags, ,
            ac_cv_mex_ldflags="$ac_cv_mex_ldflags $ac_arg")
          ;;   
          # ignore everything else
      esac
  done
  
  # restore positional arguments
  set X $ac_save_positional; shift

  MEX_VERSION_C=$ax_cv_mex_version

  AC_MSG_CHECKING([for CPPFLAGS needed to build mex objects])
  if test "x$ac_cv_mex_cppflags" = "x" ; then
    AC_MSG_RESULT([none])
  else
    MEX_CPPFLAGS=`echo $ac_cv_mex_cppflags | sed 's/^[ \t]*//;s/[ \t]*$//'`
    AC_MSG_RESULT([$MEX_CPPFLAGS])
  fi
  AC_MSG_CHECKING([for INCLUDES needed to build mex objects])
  if test "x$ac_cv_mex_includes" = "x" ; then
    AC_MSG_RESULT([none])
  else
    MEX_INCLUDES=`echo $ac_cv_mex_includes | sed 's/^[ \t]*//;s/[ \t]*$//'`
    AC_MSG_RESULT([$MEX_INCLUDES])
  fi
  AC_MSG_CHECKING([for CFLAGS needed to build mex objects])
  if test "x$ac_cv_mex_cflags" = "x" ; then
    AC_MSG_RESULT([none])
  else
    MEX_CFLAGS=`echo $ac_cv_mex_cflags | sed 's/^[ \t]*//;s/[ \t]*$//'`
    AC_MSG_RESULT([$MEX_CFLAGS])
  fi
  AC_MSG_CHECKING([for LIBS needed to build mex objects])
  if test "x$ac_cv_mex_libs" = "x" ; then
    AC_MSG_RESULT([none])
  else
    MEX_LIBS=`echo $ac_cv_mex_libs | sed 's/^[ \t]*//;s/[ \t]*$//'`
    AC_MSG_RESULT([$MEX_LIBS])
  fi
  AC_MSG_CHECKING([for LDFLAGS needed to build mex objects])
  if test "x$ac_cv_mex_ldflags" = "x" ; then
    AC_MSG_RESULT([none])
  else
    MEX_LDFLAGS=`echo $ac_cv_mex_ldflags | sed 's/^[ \t]*//;s/[ \t]*$//'`
    AC_MSG_RESULT([$MEX_LDFLAGS])
  fi
else
  ac_cv_mex_working=no
  AC_MSG_RESULT([$ac_cv_mex_working])
fi

AC_SUBST(MEX_VERSION_C)
AC_SUBST(MEX_CPPFLAGS)
AC_SUBST(MEX_INCLUDES)
AC_SUBST(MEX_CFLAGS)
AC_SUBST(MEX_LIBS)
AC_SUBST(MEX_LDFLAGS)

])

# AX_MEX_CONDITIONAL
# ---------------------
# Define Matlab conditional for GNU Automake.
AC_DEFUN([AX_MEX_CONDITIONAL],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_CC_MEX])
AM_CONDITIONAL(MEX, test x$ac_cv_mex_working = xyes)
AM_CONDITIONAL(MEX_VERSION_C, test x$ax_cv_mex_version != x)
])

dnl ccmex.m4 ends here

# AX_MATLAB_SYS_ZLIB
# ------------
# Matlab preloads an old version of zlib which means that we cannot
# just dynamically link against the libz.so found by the linker.
# Instead we search for a working version of zlib in the system 
# location and use that.
AC_DEFUN([AX_MATLAB_SYS_ZLIB],
[dnl
AC_REQUIRE([AX_PATH_MEX])
AC_LANG([C])

ax_matlab_sys_zlib=

if test x$ax_cv_mexext != xunknown && test x$ax_cv_mexext != x ; then
  # Where should we search for libraries
  ax_sys_lib_search_path="/lib /usr/lib /usr/local/lib"

  # If this is a 64 bit link box look in the place where redhat keeps libs
  if test x$ax_cv_mexext = xmexa64; then
    ax_sys_lib_search_path="/lib64 /usr/lib64 /usr/local/lib64 $ax_sys_lib_search_path"
  fi

  # set the extension of the library we are looking for
  if test x$ax_cv_mexext = xmexmac || test x$ax_cv_mexext = xmexmaci ; then
    ax_zlib_lib_ext=".dylib"
  else
    ax_zlib_lib_ext=".a"
  fi

  for lib_path in $ax_sys_lib_search_path ; do
    ax_matlab_search_zlib=$lib_path/libz$ax_zlib_lib_ext

   AC_CHECK_FILE([$ax_matlab_search_zlib],
     [
       AC_MSG_CHECKING([for gzungetc in $ax_matlab_search_zlib])
       ac_save_LIBS=$LIBS
       LIBS="$ax_matlab_search_zlib $LIBS"
       AC_LINK_IFELSE(
         [ AC_LANG_PROGRAM( ,[[gzungetc();]]) ],
         [ 
           AC_MSG_RESULT([yes]) 
           ax_matlab_sys_zlib=$ax_matlab_search_zlib
         ],
         [ AC_MSG_RESULT([no]) ]
       )
       LIBS=$ac_save_LIBS
     ], )
    
    if test x$ax_matlab_sys_zlib != x ; then
      break
    fi
  done
fi

MATLAB_SYS_ZIB=$ax_matlab_sys_zlib

AC_SUBST([MATLAB_SYS_ZIB])

])


##### http://autoconf-archive.cryp.to/check_zlib.html
#
# SYNOPSIS
#
#   CHECK_ZLIB()
#
# DESCRIPTION
#
#   This macro searches for an installed zlib library. If nothing was
#   specified when calling configure, it searches first in /usr/local
#   and then in /usr. If the --with-zlib=DIR is specified, it will try
#   to find it in DIR/include/zlib.h and DIR/lib/libz.a. If
#   --without-zlib is specified, the library is not searched at all.
#
#   If either the header file (zlib.h) or the library (libz) is not
#   found, the configuration exits on error, asking for a valid zlib
#   installation directory or --without-zlib.
#
#   The macro defines the symbol HAVE_LIBZ if the library is found. You
#   should use autoheader to include a definition for this symbol in a
#   config.h file. Sample usage in a C/C++ source is as follows:
#
#     #ifdef HAVE_LIBZ
#     #include <zlib.h>
#     #endif /* HAVE_LIBZ */
#
# LAST MODIFICATION
#
#   2004-09-20
#
# COPYLEFT
#
#   Copyright (c) 2004 Loic Dachary <loic@senga.org>
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License as
#   published by the Free Software Foundation; either version 2 of the
#   License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#   02111-1307, USA.
#
#   As a special exception, the respective Autoconf Macro's copyright
#   owner gives unlimited permission to copy, distribute and modify the
#   configure scripts that are the output of Autoconf when processing
#   the Macro. You need not follow the terms of the GNU General Public
#   License when using or distributing such scripts, even though
#   portions of the text of the Macro appear in them. The GNU General
#   Public License (GPL) does govern all other use of the material that
#   constitutes the Autoconf Macro.
#
#   This special exception to the GPL applies to versions of the
#   Autoconf Macro released by the Autoconf Macro Archive. When you
#   make and distribute a modified version of the Autoconf Macro, you
#   may extend this special exception to the GPL to apply to your
#   modified version as well.

AC_DEFUN([CHECK_ZLIB], [
AC_ARG_WITH([zlib], [AS_HELP_STRING([--with-zlib=DIR], [root directory path of zlib installation (defaults to /usr/local or /usr if not found in /usr/local), --without-zlib to disable zlib usage completely])], [], [with_zlib=yes])

if test "x$with_zlib" != xno ; then
  if test "x$with_zlib" != xyes ; then
    ZLIB_HOME=$with_zlib
  else
    # default locations
    ZLIB_HOME=/usr/local
    if test ! -f "${ZLIB_HOME}/include/zlib.h"
    then
      ZLIB_HOME=/usr
    fi
  fi

  ZLIB_OLD_LDFLAGS=$LDFLAGS
  ZLIB_OLD_CPPFLAGS=$LDFLAGS
  LDFLAGS="$LDFLAGS -L${ZLIB_HOME}/lib"
  CPPFLAGS="$CPPFLAGS -I${ZLIB_HOME}/include"
  AC_LANG_PUSH([C])
  AC_CHECK_HEADERS([zlib.h])
  AC_CHECK_LIB([z], [inflateEnd])
  AC_LANG_POP([C])

  if test "x$ac_cv_header_zlib_h" = "xyes" -a "x$ac_cv_lib_z_inflateEnd" = "xyes" ; then
    AC_MSG_RESULT([zlib found in $ZLIB_HOME])
    AC_SUBST([HAVE_LIBZ], [$ac_cv_lib_z_inflateEnd])
  else
    LDFLAGS="$ZLIB_OLD_LDFLAGS"
    CPPFLAGS="$ZLIB_OLD_CPPFLAGS"
    AC_MSG_ERROR(either specify a valid zlib installation with --with-zlib=DIR or disable zlib usage with --without-zlib)
  fi
fi])
