/*!\file: balancedthickness2_core.cpp
 * \brief: core of the balancedthickness2 solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../include/macros.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./parallel.h"
#include "../modules.h"

void balancedthickness2_core(DataSet* results,Model* model){

	extern int my_rank;

	/*output: */
	Result* result=NULL;

	/*intermediary: */
	Vec vx_g=NULL;
	Vec vy_g=NULL;

	/*solutions: */
	Vec h_g=NULL;

	/*flags: */
	int verbose=0;
	int numberofdofspernode;
	int numberofnodes;
	int numberofvertices;
	int dofs[1]={1};

	/*fem balancedthickness2 model: */
	FemModel* fem_p=NULL;


	fem_p=model->GetFormulation(Balancedthickness2AnalysisEnum);

	//first recover parameters common to all solutions
	model->FindParam(&verbose,VerboseEnum);
	model->FindParam(&numberofnodes,NumberOfNodesEnum);
	model->FindParam(&numberofvertices,NumberOfVerticesEnum);
	model->FindParam(&numberofdofspernode,NumberOfDofsPerNodeEnum);

	_printf_("depth averaging velocity...\n");
	//vx_g=inputs->Get("vx",&dofs[0],1);
	//vy_g=inputs->Get("vy",&dofs[0],1);
	/* NOT WORKING YET....
	FieldDepthAveragex(vx_g, fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,"vx");
	FieldDepthAveragex(vy_g, fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,"vy");
	*/
	//inputs->Add("vx_average",vx_g,1,numberofvertices);
	//inputs->Add("vy_average",vy_g,1,numberofvertices);
	ISSMERROR("not supported yet!");
	
	_printf_("call computational core:\n");
	diagnostic_core_linear(&h_g,fem_p,Balancedthickness2AnalysisEnum,NoneAnalysisEnum);

	_printf_("Averaging over vertices:\n");
	FieldAverageOntoVerticesx(&h_g,fem_p->elements,fem_p->nodes,fem_p->vertices,fem_p->loads,fem_p->materials,fem_p->parameters);

//	_printf_("extrude computed thickness on all layers:\n");
//	FieldExtrudex( h_g, fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,"thickness",0);

	/*Plug results into output dataset: */
	result=new Result(results->Size()+1,0,1,"h_g",h_g);
	results->AddObject(result);

	/*Free ressources:*/
	VecFree(&vx_g);
	VecFree(&vy_g);
	VecFree(&h_g);
}
