/*\file ControlConstrain.c
 *\brief: constrain updated parameters during inverse control run
 */

#include "./ControlConstrain.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	double*  p_g=NULL;
	double   cm_min;
	double   cm_max;
	int      control_type=NULL;
	int      gsize;
	Parameters* parameters=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ControlConstrainUsage);

	/*Input datasets: */
	FetchData(&p_g,&gsize,PG);
	FetchParams(&parameters,PARAMETERS);

	parameters->FindParam(&cm_min,CmMinEnum);
	parameters->FindParam(&cm_max,CmMaxEnum);
	parameters->FindParam(&control_type,ControlTypeEnum);

	/*!Call core code: */
	ControlConstrainx(p_g,gsize,cm_min,cm_max,control_type);

	/*write output : */
	WriteData(PGOUT,p_g,gsize);

	/*Free ressources: */
	delete parameters;

	/*end module: */
	MODULEEND();
}

void ControlConstrainUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [p_g] = %s(p_g,parameters);\n",__FUNCT__);
	_printf_("\n");
}
