/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{

	/*Datasets {{{1*/
	ConstraintsEnum,
	DatasetsEnum,
	ElementsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ParametersEnum,
	ResultsEnum,
	VerticesEnum,
	/*}}}*/
	/*Analysis types {{{1 */
	AnalysisEnum,
	AnalysisTypeEnum,
	SubAnalysisTypeEnum,
	//diagnostic
	DiagnosticAnalysisEnum,
	HorizAnalysisEnum,
	HutterAnalysisEnum,
	StokesAnalysisEnum,
	VertAnalysisEnum,
	//control
	AdjointAnalysisEnum,
	ControlAnalysisEnum,
	GradientAnalysisEnum,
	InverseAnalysisEnum,
	//thermal
	ThermalAnalysisEnum,
	//transient
	TransientAnalysisEnum,
	SteadyAnalysisEnum,
	//slope
	SurfaceAnalysisEnum,
	SlopecomputeAnalysisEnum,
	BedXAnalysisEnum,
	BedYAnalysisEnum,
	BedAnalysisEnum,
	SurfaceXAnalysisEnum,
	SurfaceYAnalysisEnum,
	//prognostic
	Balancedthickness2AnalysisEnum,
	BalancedthicknessAnalysisEnum,
	BalancedvelocitiesAnalysisEnum,
	Prognostic2AnalysisEnum,
	PrognosticAnalysisEnum,
	//melting
	MeltingAnalysisEnum,
	//mesh2grid
	Mesh2gridAnalysisEnum,
	//parameters
	ParametersAnalysisEnum,
	//steadystate
	SteadystateAnalysisEnum,
	//none
	NoneAnalysisEnum,
	/*}}}*/
	/*Formulations {{{1*/
	FormulationEnum,
	HutterFormulationEnum,
	MacAyealFormulationEnum,
	NoneFormulationEnum,
	PattynFormulationEnum,
	StokesFormulationEnum,
	/*}}}*/
	/*Objects {{{1*/
	ObjectEnum,
	HookEnum,
	/*Elements: */
	ElementEnum,
	BeamEnum,
	DofIndexingEnum,
	ElementPropertiesEnum,
	NodePropertiesEnum,
	PentaEnum,
	SingEnum,
	TriaEnum,
	/*Grids: */
	NodeEnum,
	VertexEnum,
	/*Loads: */
	LoadEnum,
	IcefrontEnum,
	NumericalfluxEnum,
	PengridEnum,
	PenpairEnum,
	QuadIceFrontEnum,
	QuadRiftFrontEnum,
	RiftfrontEnum,
	SegmentIcefrontEnum,
	SegmentRiftfrontEnum,
	/*Materials: */
	MaterialEnum,
	MaticeEnum,
	MatparEnum,
	/*Inputs: */
	InputEnum,
	BeamVertexInputEnum,
	BoolInputEnum,
	DoubleInputEnum,
	IntInputEnum,
	PentaVertexInputEnum,
	SingVertexInputEnum,
	TriaVertexInputEnum,
	/*Params: */
	ParamEnum,
	BoolParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	IntParamEnum,
	PetscMatParamEnum,
	PetscVecParamEnum,
	StringArrayParamEnum,
	StringParamEnum,
	/*Results: */
	ResultEnum,
	/*Rgb: */
	RgbEnum,
	/*Spc: */
	SpcEnum,
	/*DofVec: */
	DofVecEnum,
	/*}}}*/
	/*Geography {{{1*/
	GeographyEnum,
	IceSheetEnum,
	IceShelfEnum,
	/*}}}*/
	/*Fill {{{1*/
	WaterEnum,
	IceEnum,
	AirEnum,
	MelangeEnum,
	/*}}}*/
	/*Inputs {{{1*/
	AccumulationRateEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	ArtDiffEnum,
	BedEnum,
	BedSlopexEnum,
	BedSlopeyEnum,
	BoundaryEnum,
	CmMaxDmpSlopeEnum,
	CmMaxDmpValueEnum,
	CmMinDmpSlopeEnum,
	CmMinDmpValueEnum,
	CmNoiseDmpEnum,
	CollapseEnum,
	ConstantEnum,
	ControlTypeEnum,
	ConvergedEnum,
	DhDtEnum,
	DragCoefficientEnum,
	DragPEnum,
	DragQEnum,
	DragTypeEnum,
	DtEnum,
	ElementOnBedEnum,
	ElementOnIceShelfEnum,
	ElementOnSurfaceEnum,
	ElementOnWaterEnum,
	EpsVelEnum,
	FillEnum,
	FitEnum,
	FractionIncrementEnum,
	FrictionEnum,
	GeothermalFluxEnum,
	InternalEnum,
	KflagEnum,
	MaxPenetrationEnum,
	MeanVelEnum,
	MeltingOffsetEnum,
	MeltingRateEnum,
	NodeOnBedEnum,
	NodeOnIceSheetEnum,
	NodeOnIceShelfEnum,
	NodeOnSurfaceEnum,
	PenaltyOffsetEnum,
	PflagEnum,
	PressureEnum,
	ResetPenaltiesEnum,
	RheologyBEnum,
	RheologyNEnum,
	SegmentOnIceShelfEnum,
	StabilizeConstraintsEnum,
	StokesReconditioningEnum,
	SurfaceAreaEnum,
	SurfaceEnum,
	SurfaceSlopexEnum,
	SurfaceSlopeyEnum,
	TemperatureEnum,
	TemperatureAverageEnum,
	ThicknessEnum,
	TypeEnum,
	ViscosityOvershootEnum,
	VxAverageEnum,
	VxEnum,
	VxObsEnum,
	VxOldEnum,
	VyAverageEnum,
	VyEnum,
	VyObsEnum,
	VyOldEnum,
	VzAverageEnum,
	VzEnum,
	VzObsEnum,
	VzOldEnum,
	WeightsEnum,
	/*}}}*/
	/*Parameters{{{1*/
	BetaEnum,
	CmGradientEnum,
	CmJumpEnum,
	CmMaxEnum,
	CmMinEnum,
	ConnectivityEnum,
	ControlParameterEnum,
	ControlSteadyEnum,
	DakotaParameterEnum,
	DimEnum,
	EpsAbsEnum,
	EpsCmEnum,
	EpsRelEnum,
	EpsResEnum,
	ExtrudeParamEnum,
	HeatCapacityEnum,
	IsHutterEnum,
	IsMacAyealPattynEnum,
	IsStokesEnum,
	LatentHeatEnum,
	LowmemEnum,
	MaxIterEnum,
	MaxNonlinearIterationsEnum,
	MeltingPointEnum,
	MinMechanicalConstraintsEnum,
	MinThermalConstraintsEnum,
	NStepsEnum,
	NdtEnum,
	NumOutputEnum,
	NumRiftsEnum,
	NumberOfDofsPerNodeEnum,
	NumberOfElementsEnum,
	NumberOfNodesEnum,
	NumberOfVerticesEnum,
	OptScalEnum,
	OutputFileNameEnum,
	ParameterOutputEnum,
	PenaltyMeltingEnum,
	QmuAnalysisEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuMassFluxSegmentsEnum,
	QmuNPartEnum,
	QmuOutNameEnum,
	QmuPartEnum,
	ResponseDescriptorsEnum,
	SolverStringEnum,
	SparsityEnum,
	TolXEnum,
	VariableDescriptorsEnum,
	VerboseEnum,
	WaitOnLockEnum,
	YtsEnum
	/*}}}*/

};

/*Functions on enums: */
int EnumIsElement(int en);
int EnumIsLoad(int en);
int EnumIsMaterial(int en);
char* EnumAsString(int enum_type);
int StringAsEnum(char* string);

#endif
