function response=qmuresponse(models,results,processedresults,descriptor)
%QMURESPONSE - compute response function from model results.

if strcmpi(descriptor,'max_vel'),
	response=max(processedresults.vel);
elseif strcmpi(descriptor,'min_vel'),
	response=min(processedresults.vel);
elseif strcmpi(descriptor,'max_vx'),
	response=max(processedresults.vx);
elseif strcmpi(descriptor,'min_vx'),
	response=min(processedresults.vx);
elseif strcmpi(descriptor,'max_vy'),
	response=max(processedresults.vy);
elseif strcmpi(descriptor,'min_vy'),
	response=min(processedresults.vy);
elseif strcmpi(descriptor,'mass_flux'),
	%call mass flux module.
	m_dh=models.dh;
	m_dhu=models.dhu;
	m_ds=models.ds;
	ishutter=m_dh.parameters.ishutter;
	ismacayealpattyn=m_dhu.parameters.ismacayealpattyn;
	isstokes=m_ds.parameters.isstokes;
	if ishutter,
		response=MassFlux(m_dhu.elements,m_dhu.nodes,m_dhu.vertices,m_dhu.loads,m_dhu.materials,m_dhu.parameters,results.u_g);
	elseif ismacayealpattyn,
		response=MassFlux(m_dh.elements,m_dh.nodes,m_dh.vertices,m_dh.loads,m_dh.materials,m_dh.parameters,results.u_g);
	elseif isstokes,
		response=MassFlux(m_ds.elements,m_ds.nodes,m_ds.vertices,m_ds.loads,m_ds.materials,m_ds.parameters,results.u_g);
	else
		error('qmuresponse error message: unsupported analysis type for mass_flux computation!');
	end
else
	error(['qmuresponse error message: unknow descriptor ' descriptor]);
end
