/*!\file:  Material.h
 * \brief abstract class for Material object
 */ 


#ifndef _MATERIAL_H_
#define _MATERIAL_H_

/*Headers:*/
/*{{{1*/
class Object;
#include "../Object.h"
#include "../../toolkits/toolkits.h"
/*}}}*/

class Material: public Object{

	public: 
		virtual       ~Material(){};
		virtual void  Echo()=0;
		virtual void  DeepEcho()=0;
		virtual int   Id()=0;
		virtual int   MyRank()=0;
		virtual void  Marshall(char** pmarshalled_dataset)=0;
		virtual int   MarshallSize()=0;
		virtual void  Demarshall(char** pmarshalled_dataset)=0;
		virtual void  UpdateFromInputs(void* inputs)=0;
		virtual void  UpdateInputsFromVector(double* vector, int name, int type)=0;
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		virtual void  UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type)=0;

		int           Enum();
		
};
#endif
