/*! \file SolPar.h 
 *  \brief: header file for solpar object
 */

#ifndef _SOLPAR_H_
#define _SOLPAR_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
/*}}}*/

class SolPar: public Object{

	private: 
		/*no private data: this class is a container for quick access  to solution parameters, 
		 * found in the parameters dataset: */

	public:

		/*public members that need to be quickly accessed. All these members are pointers 
		 * within Param objects, so that if someone touches the Param object in the 
		 * parameters dataset, every element sees thoses changes. 
		 * */

		double& dt=NULL;

		SolPar();
		~SolPar();

		/*object derived functionality: */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		/*functionality: */
		void  Configure(void* parameters,int analysis_type,int sub_analysis_type);

			
};
#endif  /* _SOLPAR_H */
