/*!\file Result.h
 * \brief: header file for result object
 */

#ifndef _RESULT_H_
#define _RESULT_H_

/*Headers:*/
/*{{{1*/
#include "stdio.h"
#include "./Object.h"
#include "../toolkits/toolkits.h"
/*}}}*/

class Result: public Object{

	private: 
		int    id;
		double time;
		int    step;
		char*  fieldname;
		Vec    field;
		double* dfield;
		char*   cfield;
		int     size;

	public:

		Result();
		Result(const Result& result);
		Result(int result_id,double result_time,int result_step,char* result_fieldname,Vec result_field);
		Result(int result_id,double result_time,int result_step,char* result_fieldname,double* result_field,int result_size);
		Result(int result_id,double result_time,int result_step,char* result_fieldname,char* result_field);
		~Result();

		void  Echo();
		void  DeepEcho();
		int   Id(void); 
		int   MyRank(void);
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		double GetTime();
		void  GetField(Vec* pfield);
		void  GetField(double** pfield);
		void  GetField(char** pcfield);
		int    GetStep();
		void   WriteData(FILE* fid);
		char*  GetFieldName();

	
};

#endif  /* _RESULT_H_ */

