/*!\file Riftfront.h
 * \brief: header file for riftfront object
 */

#ifndef _RIFTFRONT_H_
#define _RIFTFRONT_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;

#define MAX_RIFTFRONT_GRIDS 2 //max number of grids on a rift flank, only 2 because 2d for now.
#define RIFTFRONTSTRING 20 //max string length
/*}}}*/

class Riftfront: public Load {

	public:
		int		id;

		Hook hnodes; //2 nodes
		Hook helements; //2 elements
		Hook hmatpar;
		
		/*computational: */
		int      penalty_lock;
		bool     active;
		bool     frozen;
		int      counter;
		bool     prestable;
		bool     material_converged;
		double   normal[2];
		double   length;
		double   fraction;
		
		Parameters* parameters; //pointer to solution parameters
		Inputs*  inputs;


		/*constructors,destructors: {{{1*/
		Riftfront();
		Riftfront(int riftfront_id,int* riftfront_node_ids, int riftfront_matpar_id);
		Riftfront(int riftfront_id,Hook* riftfront_hnodes, Hook* riftfront_hmatpar, Parameters* parameters, Inputs* riftfront_inputs);
		Riftfront(int riftfront_id,int i, IoModel* iomodel);
		~Riftfront();
		/*}}}*/
		/*object management: {{{1*/
		void  Configure(DataSet* elements,DataSet* loads,DataSet* nodes,DataSet* vertices,DataSet* materials,Parameters* parameters);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}


		/*}}}*/
		/*numerics: {{{1*/
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg,  int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,double kmax,int analysis_type,int sub_analysis_type);
		bool  PreStable();
		void  SetPreStable();
		int   PreConstrain(int* punstable,  int analysis_type);
		int   Constrain(int* punstable,  int analysis_type);
		void  FreezeConstraints( int analysis_type);
		bool  IsFrozen(void);
		int   Penetration(double* ppenetration,  int analysis_type);
		int   MaxPenetration(double* ppenetration,  int analysis_type);
		int   PotentialUnstableConstraint(int* punstable,  int analysis_type);
		int   IsMaterialStable( int analysis_type);
		void  OutputProperties(Vec riftproperties);
		/*}}}*/
};

#endif  /* _RIFTFRONT_H_ */
