/*! \file Penta.h 
 *  \brief: header file for penta object
 */

#ifndef _PENTA_H
#define _PENTA_H

/*Headers:*/
/*{{{1*/

#include "../Elements/Element.h"
class  Object;
class  Hook;
class  Parameters;
class  Inputs;

class IoModel;

#include "../../shared/Exceptions/exceptions.h"
#include "../../include/macros.h"

/*}}}*/

class Penta: public Element{

	public:

		int id;
		Hook hnodes;  //hook to 6 nodes
		Hook hmatice; //hook to 1 matice
		Hook hmatpar; //hook to 1 matpar

		Parameters* parameters; //pointer to solution parameters
		Inputs* inputs;

		/*FUNCTION constructors, destructors {{{1*/
		Penta();
		Penta(int penta_id,int* penta_node_ids, int penta_matice_id, int penta_matpar_id);
		Penta(int penta_id,Hook* penta_hnodes, Hook* penta_hmatice, Hook* penta_hmatpar, Parameters* penta_parameters, Inputs* inputs);
		Penta(int penta_id,int i, IoModel* iomodel);
		~Penta();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		void  Configure(DataSet* loads,DataSet* nodes,DataSet* materials,Parameters* parameters);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void*  SpawnTria(int g0, int g1, int g2);
		void  SetClone(int* minranks);

		/*}}}*/
		/*FUNCTION element numerical routines {{{1*/
		void  CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticHoriz( Mat Kgg,  int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticVert( Mat Kgg,  int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg,  int analysis_type,int sub_analysis_type);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void* GetMatPar();
		bool   GetShelf();
		void  GetNodes(void** nodes);
		bool   GetOnBed();
		void  Du(Vec du_g,int analysis_type,int sub_analysis_type);
		void  Gradj(Vec grad_g,int analysis_type,int sub_analysis_type,char* control_type);
		void  GradjDrag(Vec grad_g,int analysis_type,int sub_analysis_type);
		void  GradjB(Vec grad_g,int analysis_type,int sub_analysis_type);
		double Misfit(int analysis_type,int sub_analysis_type);
		double SurfaceArea(int analysis_type,int sub_analysis_type);
		double CostFunction(int analysis_type,int sub_analysis_type);
		
		void          GetThicknessList(double* thickness_list);
		void          GetBedList(double* bed_list);

		void  GetStrainRate(double* epsilon, double* velocity, double* xyz_list, double* gauss_coord);
		void  GetB(double* pB, double* xyz_list, double* gauss_coord);
		void  GetBPrime(double* B, double* xyz_list, double* gauss_coord);
		void  GetB_vert(double* B, double* xyz_list, double* gauss_coord);
		void  GetBPrime_vert(double* B, double* xyz_list, double* gauss_coord);
		void  GetJacobianDeterminant(double*  Jdet, double* xyz_list,double* gauss_coord);
		void  GetNodalFunctionsDerivatives(double* dh1dh6,double* xyz_list, double* gauss_coord);
		void  GetJacobian(double* J, double* xyz_list,double* gauss_coord);
		void  GetNodalFunctionsDerivativesReference(double* dl1dl6,double* gauss_coord);
		void  GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss_coord);
		void  CreatePVectorDiagnosticHoriz( Vec pg, int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticVert( Vec pg, int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pvalue, double* v_list,double* gauss_coord);
		void  GetParameterDerivativeValue(double* p, double* p_list,double* xyz_list, double* gauss_coord);
		void  GetNodalFunctions(double* l1l6, double* gauss_coord);
		void  FieldExtrude(Vec field,double* field_serial,char* field_name, int iscollapsed);
		void  ComputeBasalStress(Vec sigma_b,int analysis_type,int sub_analysis_type);
		void  ComputePressure(Vec p_g,int analysis_type,int sub_analysis_type);
		void  ComputeStrainRate(Vec eps,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixSlopeCompute(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorSlopeCompute( Vec pg,  int analysis_type,int sub_analysis_type);
		void  CreateKMatrixPrognostic(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorPrognostic( Vec pg,  int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedthickness(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedvelocities(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticStokes( Mat Kgg,  int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedthickness( Vec pg, int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedvelocities( Vec pg, int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticStokes( Vec pg, int analysis_type,int sub_analysis_type);
		void  ReduceMatrixStokes(double* Ke_reduced, double* Ke_temp);
		void  GetMatrixInvert(double*  Ke_invert, double* Ke);
		void  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		void  GetStrainRateStokes(double* epsilon, double* velocity, double* xyz_list, double* gauss_coord);
		void  GetBStokes(double* B, double* xyz_list, double* gauss_coord);
		void  GetBprimeStokes(double* B_prime, double* xyz_list, double* gauss_coord);
		void  GetLStokes(double* LStokes, double* gauss_coord_tria);
		void  GetLprimeStokes(double* LprimeStokes, double* xyz_list, double* gauss_coord_tria, double* gauss_coord);
		void  GetNodalFunctionsDerivativesStokes(double* dh1dh7,double* xyz_list, double* gauss_coord);
		void  GetNodalFunctionsDerivativesReferenceStokes(double* dl1dl7,double* gauss_coord);
		void  ReduceVectorStokes(double* Pe_reduced, double* Ke_temp, double* Pe_temp);
		void  GetNodalFunctionsStokes(double* l1l7, double* gauss_coord);
		void  CreateKMatrixThermal(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  GetB_conduct(double* B_conduct, double* xyz_list, double* gauss_coord);
		void  GetB_advec(double* B_advec, double* xyz_list, double* gauss_coord);
		void  GetBprime_advec(double* Bprime_advec, double* xyz_list, double* gauss_coord);
		void  GetB_artdiff(double* B_artdiff, double* xyz_list, double* gauss_coord);
		void  CreateKMatrixMelting(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorThermal( Vec pg, int analysis_type,int sub_analysis_type);
		void  CreatePVectorMelting( Vec pg, int analysis_type,int sub_analysis_type);
		void  GetPhi(double* phi, double*  epsilon, double viscosity);
		double MassFlux(double* segment,double* ug);

		/*updates: */
		void  UpdateFromDakota(void* inputs);
		void  UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type);
		void  UpdateInputsFromSolutionDiagnosticHoriz( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionSlopeCompute( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionPrognostic( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionPrognostic2(double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionBalancedthickness( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionBalancedthickness2( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionBalancedvelocities( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}


		/*}}}*/


};
#endif  /* _PENTA_H */
