/*! \file BoolInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BOOLINPUT_H_
#define _BOOLINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../../include/types.h"
/*}}}*/

class BoolInput: public Input{

	private: 
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmBool value;

	public:

		/*constructors, destructors: {{{1*/
		BoolInput();
		BoolInput(int enum_type,IssmBool value);
		~BoolInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}


		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue);
		void GetParameterValue(int* pvalue);
		void GetParameterValue(double* pvalue);
		void GetParameterValue(double* pvalue,Node* node);
		void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord);
		void GetParameterValue(double* pvalue,double* gauss);
		void GetParameterValue(double* pvalue,double* gauss,double defaultvalue);
		
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss);
		void GetStrainRate(double* epsilon,Input* yinput, double* xyz_list, double* gauss);
		void GetStrainRateStokes(double* epsilon,Input* yinput, Input* zinput, double* xyz_list, double* gauss);
		void ChangeEnum(int newenumtype);
		/*}}}*/

};
#endif  /* _BOOLINPUT_H */
