/*!\file: slope_core.cpp
 * \brief: core of the slope solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules.h"

void slope_core(Vec* pslopex,Vec* pslopey,FemModel* fem,int AnalysisEnum){

	/*parameters: */
	int verbose;
	int dim;
	int xanalysis;
	int yanalysis;

	/*output: */
	Vec slopex=NULL;
	Vec slopey=NULL; 

	fem->parameters->FindParam(&verbose,VerboseEnum);
	fem->parameters->FindParam(&dim,DimEnum);

	if(verbose)_printf_("%s\n","computing surface slope (x and y derivatives)...");

	if(AnalysisEnum==SurfaceAnalysisEnum){
		xanalysis=SurfaceXAnalysisEnum;
		yanalysis=SurfaceYAnalysisEnum;
	}
	else if(AnalysisEnum==BedAnalysisEnum){
		xanalysis=BedXAnalysisEnum;
		yanalysis=BedYAnalysisEnum;
	}
	else ISSMERROR("%s%s%s"," analysis ",EnumAsString(AnalysisEnum)," not supported yet!");

	diagnostic_core_linear(&slopex,fem,SlopecomputeAnalysisEnum,xanalysis);
	diagnostic_core_linear(&slopey,fem,SlopecomputeAnalysisEnum,yanalysis);

	
	if (dim==3){
		
		if(verbose)_printf_("%s\n","extruding slopes in 3d...");
		FieldExtrudex( slopex, fem->elements,fem->nodes,fem->vertices,fem->loads,fem->materials,fem->parameters,"slopex",0);
		FieldExtrudex( slopey, fem->elements,fem->nodes,fem->vertices,fem->loads,fem->materials,fem->parameters,"slopex",0);
	}

	/*Assign output pointers:*/
	*pslopex=slopex;
	*pslopey=slopey;
}
