/*!\file: Sing.h
 * \brief prototypes for Sing element
 */ 

#ifndef _SING_H_
#define  _SING_H_

/*Headers:*/
/*{{{1*/
#include "./Element.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;

#include "../../include/macros.h"
#include "../../shared/Exceptions/exceptions.h"

/*}}}*/

class Sing: public Element{

	public:

		/*ids:*/
		int id;

		Hook hnodes;  //hook to 2 nodes
		Hook hmatice; //hook to 1 matice
		Hook hmatpar; //hook to 1 matpar
		
		Parameters* parameters; //pointer to solution parameters
		Inputs* inputs;


		/*constructors, destructors: {{{1*/
		Sing();
		Sing(int sing_id,int* sing_node_ids, int sing_matice_id, int sing_matpar_id);
		Sing(int sing_id,Hook* sing_hnodes, Hook* sing_hmatice, Hook* sing_hmatpar, Parameters* sing_parameters,Inputs* sing_inputs);
		Sing(int sing_id, int i, IoModel* iomodel);
		~Sing();
		/*}}}*/
		/*object management: {{{1*/
		void  Configure(DataSet* loads,DataSet* nodes,DataSet* materials,Parameters* parameters);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  SetClone(int* minranks);
		int   MyRank();
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type);

		/*}}}*/
		/*numerics: {{{1*/
		void  CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg,  int analysis_type,int sub_analysis_type);
				void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void  CreateKMatrixDiagnosticHutter(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pp, double* plist, double* gauss_l1l2l3);
		void  CreatePVectorDiagnosticHutter(Vec pg,int analysis_type,int sub_analysis_type);
		void* GetMatPar();
		void  ComputeBasalStress(Vec sigma_b,int analysis_type,int sub_analysis_type);
		void  ComputePressure(Vec p_g,int analysis_type,int sub_analysis_type);
		void  ComputeStrainRate(Vec eps,int analysis_type,int sub_analysis_type);
		void  GetNodes(void** vpnodes);
		/*}}}*/
		/*not implemented: {{{1*/
		bool   GetShelf();
		bool   GetOnBed();
		void  GetBedList(double*);
		void  GetThicknessList(double* thickness_list);
		void  Du(Vec,int,int);
		void  Gradj(Vec, int, int,char*);
		void  GradjDrag(Vec , int,int);
		void  GradjB(Vec,  int,int);
		double Misfit(int,int);
		double SurfaceArea(int,int);
		double CostFunction(int,int);
		double MassFlux(double* segment,double* ug);
		/*}}}*/



};
#endif //ifndef _SING_H_

