/*\file Dof.c
 *\brief: build degrees of freedom for every grid.
 */

#include "./Dof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* elements=NULL;
	Parameters* params=NULL;

	/* output datasets: */
	DofVec* partition=NULL;
	DofVec* tpartition=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&DofUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODESIN);
	FetchData(&vertices,VERTICESIN);
	FetchData((DataSet**)&params,PARAMS);

	/*!Generate internal degree of freedom numbers: */
	Dofx(&partition, &tpartition,elements,nodes, vertices, params); 

	/*partition and tpartition should be incremented by 1: */
	VecShift(partition->vector,1.0); //matlab indexing starts at 1.
	VecShift(tpartition->vector,1.0);

	/*write output datasets: */
	WriteData(NODES,nodes);
	WriteData(VERTICES,vertices);
	WriteData(PARTITION,partition);
	WriteData(TPARTITION,tpartition);

	/*Free ressources: */
	delete nodes;
	delete vertices;
	delete elements;
	delete params;
	delete partition;
	delete tpartition;

	/*end module: */
	MODULEEND();
}

void DofUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [nodes,part,tpart] = %s(elements, nodes,params);\n",__FUNCT__);
	_printf_("\n");
}
