/*\file Qmu.c
 *\brief: launch solution core using Dakota engine.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Qmu.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	mxArray* models=NULL;
	int      analysis_type;
	int      sub_analysis_type;
	char*    dakota_input_file=NULL;
	char*    dakota_output_file=NULL;
	char*    dakota_error_file=NULL;

	/* output datasets: none*/

	#ifndef _HAVE_DAKOTA_ //only works if dakota library has been compiled in.
	ISSMERROR(" Dakota not available! Cannot carry out qmu analysis!");
	#endif

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&QmuUsage);

	/*Input datasets: */
	models=MODELS;
	
	FetchData(&analysis_type,mxGetField(PARAMETERS,0,"analysis_type"));
	FetchData(&sub_analysis_type,mxGetField(PARAMETERS,0,"sub_analysis_type"));
	FetchData(&dakota_input_file,mxGetField(PARAMETERS,0,"qmuinname"));
	FetchData(&dakota_output_file,mxGetField(PARAMETERS,0,"qmuoutname"));
	FetchData(&dakota_error_file,mxGetField(PARAMETERS,0,"qmuerrname"));

	/*!Generate internal degree of freedom numbers: */
	Qmux(models,analysis_type,sub_analysis_type,dakota_input_file,dakota_output_file,dakota_error_file);


	/*Free ressources:*/
	xfree((void**)&dakota_input_file);
	xfree((void**)&dakota_output_file);
	xfree((void**)&dakota_error_file);

	/*end module: */
	MODULEEND();

}

void QmuUsage(void){
	_printf_("\n");
	_printf_("   usage: %s(models,parameters);\n",__FUNCT__);
	_printf_("\n");
}
