/*!\file:  Param.h
 * \brief abstract class for Param object
 */ 


#ifndef _PARAM_H_
#define _PARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif

#include "../Object.h"
#include "../Node.h"
/*}}}*/

class Param: public Object{

	public: 
		
		virtual        ~Param(){};

		/*methods:{{{1*/
		virtual int   EnumType()=0;
		virtual void  GetParameterValue(bool* pbool)=0;
		virtual void  GetParameterValue(int* pinteger)=0;
		virtual void  GetParameterValue(double* pdouble)=0;
		virtual void  GetParameterValue(char** pstring)=0;
		virtual void  GetParameterValue(char*** pstringarray,int* pM)=0;
		virtual void  GetParameterValue(double** pdoublearray,int* pM)=0;
		virtual void  GetParameterValue(double** pdoublearray,int* pM,int* pN)=0;
		virtual void  GetParameterValue(Vec* pvec)=0;
		virtual void  GetParameterValue(Mat* pmat)=0;
		virtual char* GetParameterName(void)=0;
		virtual void  Process(double* partition,int numberofvertices)=0;
		#ifdef _SERIAL_
		virtual void  SetMatlabField(mxArray* dataref)=0;
		#endif

		/*}}}*/

};
#endif
