/*! \file IntParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _INTPARAM_H_
#define _INTPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/types.h"
#include "../../shared/shared.h"
#include "../../include/typedefs.h"
#include "../../include/macros.h"
/*}}}*/

class IntParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		IssmInt value;

	public:
		/*constructors, destructors: {{{1*/
		IntParam();
		IntParam(int enum_type,IssmInt value);
		~IntParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("Int param cannot return a bool");}
		void  GetParameterValue(int* pinteger){*pinteger=value;}
		void  GetParameterValue(double* pdouble){ISSMERROR("Int param cannot return a double");}
		void  GetParameterValue(char** pstring){ISSMERROR("Int param cannot return a string");}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("Int param cannot return a string arrayl");}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("Int param cannot return a double array");}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("Int param cannot return a double array");}
		void  GetParameterValue(Vec* pvec){ISSMERROR("Int param cannot return a Vec");}
		void  GetParameterValue(Mat* pmat){ISSMERROR("Int param cannot return a Mat");}
		char* GetParameterName(void);
		void  Process(double* partition,int numberofvertices);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _INTPARAM_H */
