/*!\file StringParam.c
 * \brief: implementation of the StringParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/typedefs.h"
#include "../../include/types.h"
#include "../../include/macros.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION StringParam::StringParam(){{{1*/
StringParam::StringParam(){
	return;
}
/*}}}*/
/*FUNCTION StringParam::StringParam(int enum_type,IssmString value){{{1*/
StringParam::StringParam(int in_enum_type,char* in_value){

	enum_type=in_enum_type;
	value=(char*)xmalloc((strlen(in_value)+1)*sizeof(char));
	strcpy(value,in_value);
	
}
/*}}}*/
/*FUNCTION StringParam::~StringParam(){{{1*/
StringParam::~StringParam(){
	xfree((void**)&value);
}
/*}}}*/

/*Object methods*/
/*FUNCTION StringParam::copy{{{1*/
Object* StringParam::copy() {
	
	return new StringParam(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION StringParam::DeepEcho{{{1*/
void StringParam::DeepEcho(void){

	printf("StringParam:\n");
	printf("   enum: %i\n",this->enum_type);
	printf("   %s\n",this->value);
}
/*}}}*/
/*FUNCTION StringParam::Demarshall{{{1*/
void  StringParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;
	int   stringsize;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);

	memcpy(&stringsize,marshalled_dataset,sizeof(int));marshalled_dataset+=sizeof(int);
	
	this->value=(char*)xmalloc(stringsize*sizeof(char));
	memcpy(this->value,marshalled_dataset,stringsize*sizeof(char));marshalled_dataset+=stringsize*sizeof(char);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION StringParam::Echo {{{1*/
void StringParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION StringParam::Enum{{{1*/
int StringParam::Enum(void){

	return StringParamEnum;

}
/*}}}*/
/*FUNCTION StringParam::Id{{{1*/
int    StringParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION StringParam::Marshall{{{1*/
void  StringParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;
	int   stringsize;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of StringParam: */
	enum_value=StringParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);

	/*marshall data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	stringsize=strlen(this->value)+1;
	
	memcpy(marshalled_dataset,&stringsize,sizeof(stringsize));marshalled_dataset+=sizeof(stringsize);
	memcpy(marshalled_dataset,this->value,stringsize*sizeof(char));marshalled_dataset+=stringsize*sizeof(char);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION StringParam::MarshallSize{{{1*/
int   StringParam::MarshallSize(){

	int stringsize;
	stringsize=strlen(this->value)+1;
	
	return sizeof(value)+
		sizeof(int)+
		stringsize*sizeof(char)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION StringParam::MyRank{{{1*/
int    StringParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION StringParam::GetParameterValue(char** pstring){{{1*/
void  StringParam::GetParameterValue(char** pstring){
	
	char* outstring=NULL;
	int   stringsize;

	stringsize=strlen(this->value)+1;

	outstring=(char*)xmalloc(stringsize*sizeof(char));
	memcpy(outstring,this->value,stringsize*sizeof(char));

	*pstring=outstring;

}
/*}}}*/
/*FUNCTION StringParam::GetParameterName(void); {{{1*/
char* StringParam::GetParameterName(void){
	return  EnumAsString(this->enum_type);
}
/*}}}*/
/*FUNCTION StringParam::SetMatlabField(mxArray* dataref);{{{1*/
void  StringParam::SetMatlabField(mxArray* dataref){
	
	char* name=NULL;

	name=this->GetParameterName();
	mxSetField( dataref, 0, name, mxCreateString(value));

	/*Free ressources:*/
	xfree((void**)&name);

}
/*}}}*/
/*FUNCTION StringParam::ProcessParams(double* partition,int numberofvertices);{{{1*/
void  StringParam::Process(double* partition,int numberofvertices){
}
/*}}}*/
