#!/bin/bash
#Synchronize EnumAsString.cpp and StringAsEnum.cpp

#first remove existing files
rm EnumAsString.cpp StringAsEnum.cpp

echo "Synchronizing EnumAsString..."
#Get all lines of EnumDefinitions2.h which hold Enum, | remove all comas | add line number in the first column > put everything in file temp
cat EnumDefinitions.h | grep "Enum," |sed -e "s/,//g" | awk '{ printf "%s %s\n", NR, $0 }' > temp

#Build header of EnumAsString.cpp {{{1
cat <<END > EnumAsString.cpp
/*
* \file EnumAsString.cpp:
* \brief: output string associated with enum
*
*   WARNING: DO NOT MODIFY THIS FILE
*            this file has been automatically generated by SynchronizeStrings.sh
*            Please read README for more information
*/

#include "../shared/shared.h"
#include "../include/macros.h"
#include "./EnumDefinitions.h"

char* EnumAsString(int en){

	switch(en){

END
#}}}
#Build header of StringAsEnum.cpp {{{1
cat <<END > StringAsEnum.cpp
/*
* \file StringAsEnum.cpp:
* \brief: output enum associated with string
*
*   WARNING: DO NOT MODIFY THIS FILE
*            this file has been automatically generated by SynchronizeStrings.sh
*            Please read README for more information
*/

#include "../shared/shared.h"
#include "../include/macros.h"
#include "./EnumDefinitions.h"

int  StringAsEnum(char* name){

END
#}}}

#get number of lines in temp
NUMBEROFLINES=$(wc -l temp | awk '{printf("%s",$1);}');

# go through the lines of temp
for i in `seq 1 1 $NUMBEROFLINES`; do

	#Get name and enum of the line i
	NAMEENUM=$(cat temp | grep "^[ ]*$i " | awk '{printf("%s",$2);}');
	NAME=$(echo $NAMEENUM | sed -e "s/Enum//g")
	ENUM=$i;
	#offset Enum by one (Enum begins with 0 and not 1!)
	let ENUM=$ENUM-1

	#print info {{{
	if [ $i -lt 10 ]
	then
		printf "\r                                                                      "
		printf "\r  $i/$NUMBEROFLINES Adding "$NAME"..."
	else
		if [ $i -lt 100 ]
		then
			printf "\r                                                                      "
			printf "\r $i/$NUMBEROFLINES Adding "$NAME"..."
		else
			printf "\r                                                                      "
			printf "\r$i/$NUMBEROFLINES Adding "$NAME"..."
		fi
	fi
	#}}}
	#Add case to EnumAsString.cpp {{{
	cat <<END >> EnumAsString.cpp
		case $NAMEENUM :
			return "$NAME";
END
#}}}
	#Add case to StringAsEnum.cpp {{{
	if [ $i -eq 1 ]
	then
		cat <<END >> StringAsEnum.cpp
	if (strcmp(name,"$NAME")==0) return $NAMEENUM;
END
	else
		cat <<END >> StringAsEnum.cpp
	else if (strcmp(name,"$NAME")==0) return $NAMEENUM;
END
	fi
#}}}

done

#Add footer of of EnumAsString.cpp{{{1
cat <<END >> EnumAsString.cpp
		default :
			ISSMERROR("Enum %i not found",en);
	}
}
END
#}}}
#Add footer of of StringAsEnum.cpp{{{1
cat <<END >> StringAsEnum.cpp
	else ISSMERROR("Enum %i not found",name);

}
END
#}}}

#clean up{{{
rm temp
#}}}
#print info {{{
printf "\r                                                                      "
printf "\rdone!\n"
#}}}
