/*\file UpdateInputsFromSolution.c
*\brief: update elements properties using a solution vector
*/

#include "./UpdateInputsFromSolution.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

/*diverse: */
int   noerr=1;

/*input datasets: */
DataSet* elements=NULL;
DataSet* nodes=NULL;
DataSet* vertices=NULL;
DataSet* loads=NULL;
DataSet* materials=NULL;
Parameters* parameters=NULL;
Vec      solution=NULL;
int               analysis_type;
int               sub_analysis_type;

/*Boot module: */
MODULEBOOT();

/*checks on arguments on the matlab side: */
CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateInputsFromSolutionUsage);

/*Input datasets: */
FetchData(&elements,ELEMENTSIN);
FetchData(&nodes,NODESIN);
FetchData(&vertices,VERTICESIN);
FetchData(&loads,LOADSIN);
FetchData(&materials,MATERIALSIN);
FetchParams(&parameters,PARAMETERSIN);
FetchData(&solution,SOLUTION);
FetchData(&analysis_type,ANALYSIS);
FetchData(&sub_analysis_type,SUBANALYSIS);

/*!Generate internal degree of freedom numbers: */
UpdateInputsFromSolutionx(elements,nodes,vertices,loads, materials,parameters,solution,analysis_type,sub_analysis_type);

/*write output datasets: */
WriteData(ELEMENTS,elements);

/*Free ressources: */
delete elements;
delete nodes;
delete vertices;
delete loads;
delete materials;
delete parameters;
VecFree(&solution);

/*end module: */
MODULEEND();
}

void UpdateInputsFromSolutionUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements] = %s(elements,nodes,vertices,loads,materials,parameters,solution,analysis_type,sub_analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
