/*\file ProcessParams.c
 *\brief: process parameters using partition vector
 */

#include "./ProcessParams.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Parameters* parameters=NULL;
	Vec partition=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ProcessParamsUsage);

	/*Input datasets: */
	FetchData(&parameters,PARAMETERSIN);
	FetchData(&partition,PARTITION);

	/*Shit partition: */
	if(partition)VecShift(partition,-1.0);


	/*!Generate internal degree of freedom numbers: */
	ProcessParamsx(parameters,partition);

	/*write output datasets: */
	WriteParams(PARAMETERSOUT,parameters);

	/*Free ressources: */
	delete parameters;
	VecFree(&partition);

	/*end module: */
	MODULEEND();
}

void ProcessParamsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [parameters] = %s(parameters,partition);\n",__FUNCT__);
	_printf_("\n");
}
