/*\file Misfit.c
 *\brief: compute misfit between modeled velocity and observed velocity
 */

#include "./Misfit.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	ParameterInputs* inputs=NULL;
	int               analysis_type;
	int               sub_analysis_type;

	/* output datasets: */
	double J;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MisfitUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&analysis_type,ANALYSIS);
	FetchData(&sub_analysis_type,SUBANALYSIS);

	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	/*!Call core code: */
	Misfitx(&J, elements,nodes,vertices,loads,materials,parameters,inputs,analysis_type,sub_analysis_type);

	/*write output : */
	WriteData(MISFIT,J);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	delete inputs;

	/*end module: */
	MODULEEND();
}

void MisfitUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [J] = %s(elements,nodes,vertices,loads, materials, parameters, inputs);\n",__FUNCT__);
	_printf_("\n");
}
