/*\file FieldExtrude.c
 *\brief: extrude field vertically
 */

#include "./FieldExtrude.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	Vec      field=NULL;
	char*    field_name=NULL;
	int      collapse=0;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&FieldExtrudeUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&field,FIELD);
	FetchData(&field_name,FIELDNAME);
	FetchData(&collapse,COLLAPSE);

	/*!Call core code: */
	FieldExtrudex(field,elements,nodes,vertices,loads,materials,parameters,field_name,collapse);

	/*write output : */
	WriteData(FIELDOUT,field);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	VecFree(&field);
	xfree((void**)&field_name);
	
	/*end module: */
	MODULEEND();

}

void FieldExtrudeUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [field] = %s(elements, nodes, vertices, loads, materials, parameters, field, field_name, collapse);\n",__FUNCT__);
	_printf_("\n");
}
