/*\file Du.c
 *\brief: compute diff between observed and modeled velocity
 */

#include "./Du.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	ParameterInputs* inputs=NULL;
	int               analysis_type;
	int               sub_analysis_type;

	/* output datasets: */
	Vec du_g=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&DuUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&analysis_type,ANALYSIS);
	FetchData(&sub_analysis_type,SUBANALYSIS);

	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	/*!Call core code: */
	Dux(&du_g, elements,nodes,vertices, loads,materials,parameters,inputs,analysis_type,sub_analysis_type);

	/*write output : */
	WriteData(DUG,du_g);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	VecFree(&du_g);
	delete inputs;

	/*end module: */
	MODULEEND();
}

void DuUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [du_g] = %s(lements,nodes,vertices,loads,materials, parameters,inputs);\n",__FUNCT__);
	_printf_("\n");
}
