/*!\file: balancedvelocities_core.cpp
 * \brief: core of the balancedvelocities solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./parallel.h"
#include "../issm.h"

void balancedvelocities_core(DataSet* results,Model* model,ParameterInputs* inputs){

	extern int my_rank;

	/*output: */
	Result* result=NULL;

	/*intermediary: */
	Vec u_g=NULL;

	/*solutions: */
	Vec v_g=NULL;

	/*flags: */
	int verbose=0;
	int numberofdofspernode;
	int numberofnodes;
	int dofs[2]={1,1};

	/*fem balancedvelocities model: */
	FemModel* fem_p=NULL;


	/*recover fem model: */
	fem_p=model->GetFormulation(BalancedvelocitiesAnalysisEnum);

	//first recover parameters common to all solutions
	model->FindParam(&verbose,VerboseEnum);
	model->FindParam(&numberofnodes,NumberOfNodesEnum);
	model->FindParam(&numberofdofspernode,NumberOfDofsPerNodeEnum);

	_printf_("depth averaging velocity...\n");
	u_g=inputs->Get("velocity",&dofs[0],2); //take (vx,vy) from inputs velocity
	FieldDepthAveragex( u_g, fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,"velocity");
	inputs->Add("velocity_average",u_g,2,numberofnodes);
	
	_printf_("call computational core:\n");
	diagnostic_core_linear(&v_g,fem_p,inputs,BalancedvelocitiesAnalysisEnum,NoneAnalysisEnum);

	_printf_("extrude computed thickness on all layers:\n");
	FieldExtrudex( v_g, fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,"thickness",0);

	/*Plug results into output dataset: */
	result=new Result(results->Size()+1,0,1,"v_g",v_g);
	results->AddObject(result);

	/*Free ressources:*/
	VecFree(&u_g);
	VecFree(&v_g);
}
