/*
 * FemModel.h: 
 */

#ifndef _FEMMODEL_H_
#define _FEMMODEL_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "../toolkits/toolkits.h"
class DataSet;
class Parameters;
class DofVec;
class NodeSets;
/*}}}*/

class FemModel: public Object{

	/*no private members, as we need access to these datasets quite often!:*/

	public:

		DataSet*            elements;
		DataSet*            nodes;
		DataSet*            vertices;
		DataSet*            constraints;
		DataSet*            loads;
		DataSet*            materials;
		Parameters*         parameters;

		DofVec*             partition;
		DofVec*             tpartition;
		DofVec*             yg;

		Mat                 Rmg;
		NodeSets*           nodesets;
		Vec                 ys;
		Vec                 ys0;
		Mat                 Gmn;

		FemModel();
		~FemModel();
		FemModel(DataSet* elements,DataSet* nodes,DataSet* vertices, DataSet* constraints,DataSet* loads,DataSet* materials,Parameters* parameters,
			              DofVec* partition,DofVec* tpartition,DofVec* yg,Mat Rmg,Mat Gmn,NodeSets* nodesets,Vec ys,Vec ys0);
     
		/*virtual resolves: */
		void  Echo();
		void  DeepEcho();
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		
		int FindParam(double* pscalar,int enum_type);
		int FindParam(int* pinteger,int enum_type);
		int FindParam(char** pstring,int enum_type);
		int FindParam(char*** pstringarray,int* pM,int enum_type);
		int FindParam(double** pdoublearray,int* pM, int* pN,int enum_type);
		int FindParam(Vec* pvec,int enum_type);
		int FindParam(Mat* pmat,int enum_type);
		DataSet* get_elements(void);
		DataSet* get_nodes(void);
		DataSet* get_vertices(void);
		DataSet* get_constraints(void);
		DataSet* get_loads(void);
		DataSet* get_materials(void);
		Parameters* get_parameters(void);
		DofVec*      get_partition(void);
		DofVec*      get_tpartition(void);
		DofVec*      get_yg(void);
		Mat      get_Rmg(void);
		NodeSets* get_nodesets(void);
		Vec      get_ys(void);
		Vec      get_ys0(void);
		Mat      get_Gmn(void);

		void    UpdateInputsFromVector(double* vector, int name, int type);
		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type);

};


#endif
