/*! \file Tria.h 
 *  \brief: header file for tria object
 */

#ifndef _TRIA_H_
#define _TRIA_H_

/*Headers:*/
/*{{{1*/
#include "./Element.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;

#include "../../include/macros.h"
#include "../../shared/Exceptions/exceptions.h"
/*}}}*/

class Tria: public Element{

	public:

		int  id;

		Hook hnodes;  //hook to 3 nodes
		Hook hmatice; //hook to 1 matice
		Hook hmatpar; //hook to 1 matpar

		Parameters* parameters; //pointer to solution parameters
		Inputs*  inputs;

		/*FUNCTION constructors, destructors {{{1*/
		Tria();
		Tria(int tria_id,int* tria_node_ids, int tria_matice_id, int tria_matpar_id);
		Tria(int tria_id,Hook* tria_hnodes, Hook* tria_hmatice, Hook* tria_hmatpar, Parameters* parameters, Inputs* tria_inputs);
		Tria(int tria_id,int i, IoModel* iomodel);
		~Tria();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		void  Configure(DataSet* loads,DataSet* nodes,DataSet* materials,Parameters* parameters);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  SetClone(int* minranks);
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type);

		/*}}}*/
		/*FUNCTION element numerical routines {{{1*/
		void  CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg,  int analysis_type,int sub_analysis_type);
				void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void  CreateKMatrixDiagnosticHoriz(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticHorizFriction(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticSurfaceVert(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixSlopeCompute(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pp, double* plist, double* gauss_l1l2l3);
		void  GetParameterDerivativeValue(double* p, double* plist,double* xyz_list, double* gauss_l1l2l3);
		void  GetStrainRate(double* epsilon, double* velocity, double* xyz_list, double* gauss_l1l2l3);
		void  GetJacobianDeterminant2d(double*  Jdet, double* xyz_list,double* gauss_l1l2l3);
		void  GetJacobianDeterminant3d(double*  Jdet, double* xyz_list,double* gauss_l1l2l3);
		void  GetB(double* B, double* xyz_list, double* gauss_l1l2l3);
		void  GetBPrime(double* Bprime, double* xyz_list, double* gauss_l1l2l3);
		void  GetL(double* L, double* xyz_list, double* gauss_l1l2l3,int numdof);
		void  GetB_prog(double* B_prog, double* xyz_list, double* gauss_l1l2l3);
		void  GetBPrime_prog(double* Bprime_prog, double* xyz_list, double* gauss_l1l2l3);
		void  GetNodalFunctions(double* l1l2l3, double* gauss_l1l2l3);
		void  GetNodalFunctionsDerivatives(double* dh1dh3,double* xyz_list, double* gauss_l1l2l3);
		void  GetNodalFunctionsDerivativesReference(double* dl1dl3,double* gauss_l1l2l3);
		void  GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss_l1l2l3);
		void  GetJacobian(double* J, double* xyz_list,double* gauss_l1l2l3);
		void  Du(Vec du_g,int analysis_type,int sub_analysis_type);
		void  Gradj(Vec grad_g,int analysis_type,int sub_analysis_type,char* control_type);
		void  GradjDrag(Vec grad_g,int analysis_type,int sub_analysis_type);
		void  GradjDragStokes(Vec grad_g,int analysis_type,int sub_analysis_type);
		void  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		void  GradjB(Vec grad_g,int analysis_type,int sub_analysis_type);
		double Misfit(int analysis_type,int sub_analysis_type);
		double SurfaceArea(int analysis_type,int sub_analysis_type);
		double CostFunction(int analysis_type,int sub_analysis_type);

		void  CreatePVectorDiagnosticHoriz(Vec pg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticBaseVert(Vec pg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorSlopeCompute( Vec pg,  int analysis_type,int sub_analysis_type);
		void* GetMatPar();
		bool  GetShelf();
		void  GetNodes(void** nodes);
		bool  GetOnBed();
		void  GetThicknessList(double* thickness_list);
		void  GetBedList(double* bed_list);
		void  ComputeBasalStress(Vec sigma_b,int analysis_type,int sub_analysis_type);
		void  ComputePressure(Vec p_g,int analysis_type,int sub_analysis_type);
		void  ComputeStrainRate(Vec eps,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixThermal(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixMelting(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorThermalShelf( Vec pg,  int analysis_type,int sub_analysis_type);
		void  CreatePVectorThermalSheet( Vec pg,  int analysis_type,int sub_analysis_type);
		void  CreateKMatrixPrognostic(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorPrognostic(Vec pg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixPrognostic2(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorPrognostic2(Vec pg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedthickness(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedthickness(Vec pg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedthickness2(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedthickness2(Vec pg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedvelocities(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedvelocities(Vec pg,int analysis_type,int sub_analysis_type);
		double MassFlux(double* segment,double* ug);
		double GetArea(void);
		double GetAreaCoordinate(double x, double y, int which_one);

		/*updates:*/
		void  UpdateFromDakota(void* inputs);
		void  UpdateInputsFromSolutionDiagnosticHoriz( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionSlopeCompute( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionPrognostic( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionPrognostic2(double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionBalancedthickness( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionBalancedthickness2( double* solution,int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolutionBalancedvelocities( double* solution,int analysis_type,int sub_analysis_type);
		void  AddInput(double value, int enum_type){ISSMERROR("not supporte yet!");}

		/*}}}*/

};
#endif  /* _TRIA_H */
